import os
import shutil
import subprocess
import shlex
import stat

def run(cmd_line):
    cmd_parts = shlex.split(cmd_line)
    process = subprocess.run(cmd_parts, stdout=subprocess.PIPE,
                         universal_newlines=True, check=True)
    return process.stdout

def rmtree(tree_path):
    shutil.rmtree(tree_path,
                  onerror=lambda func, path, _: (os.chmod(path, stat.S_IWRITE), func(path)))

def download(git_repo, file_path, file_name, dest_path, tmp_dir="tmp"):
    owd = os.getcwd()
    os.environ["GIT_LFS_SKIP_SMUDGE"] = '1'
    git_username = os.environ.get("SNAPSHOTS_GIT_USERNAME", None)
    git_access_token = os.environ.get("SNAPSHOTS_ACCESS_TOKEN", None)
    # git_repo = "ssh://git@hxgntech.com:7099/vs/snapshots.git"
    if git_access_token is None or git_username is None:
        git_url = f"ssh://git@{git_repo}"
    else:
        git_url = f"https://{git_username}:{git_access_token}@{git_repo}"

    out = run(f"git clone -b master --single-branch {git_url} {tmp_dir}")
    print(out)
    os.chdir(tmp_dir)
    out = run(f"git checkout HEAD -- {file_path}/{file_name}")
    print(out)
    out = run(f"git lfs pull -I {file_path}/{file_name}")
    print(out)
    shutil.copy2(f"{file_path}/{file_name}", f"{dest_path}/{file_name}")
    os.chdir(owd)
    rmtree(tmp_dir)

if __name__ == "__main__":
    download("hxgntech.com:7099/vs/snapshots.git", "PocoCapsule", "jre-1.8.zip", "./")
