/*!
 * \file
 * \author Alexander Kurz <alexander.kurz@leica-geosystems.com>
 * \date   2010-02-03
 * \brief  Enables memory leak check on Win32.
 */

#pragma once

#if !defined(COREBASE_MEMORYLEAKCHECK_H)
#define COREBASE_MEMORYLEAKCHECK_H

// Mem-check routine.
#if defined(WIN32) && !defined(_WIN32_WCE) && defined(_DEBUG)
    #ifndef _CRTDBG_MAP_ALLOC
        #define _CRTDBG_MAP_ALLOC
    #endif
    #include <stdlib.h>
    #include <crtdbg.h>
    // MFC is defining these by itself.
    #ifndef DEBUG_NEW
        #define DEBUG_NEW new(_NORMAL_BLOCK ,__FILE__, __LINE__)
        #define new DEBUG_NEW
    #endif
#endif

#endif  //  COREBASE_MEMORYLEAKCHECK_H
