if(NOT ENV{POCOCAPSULE_DIR})
    set(ENV{POCOCAPSULE_DIR} ${CMAKE_CURRENT_LIST_DIR}/..)
endif()

if(NOT POCOCAPSULE_BIN_DIR)
    set(POCOCAPSULE_BIN_DIR ${CMAKE_CURRENT_LIST_DIR}/../bin)
endif()

if(WIN32)
    set(POCO_EXE_EXT ".bat")
endif()

if(NOT POCO_PXENCODE_BINARY)
    set(POCO_PXENCODE_BINARY  ${POCOCAPSULE_BIN_DIR}/pxencode${POCO_EXE_EXT})
endif()

if(NOT POCO_PXGENPROXY_BINARY)
    set(POCO_PXGENPROXY_BINARY  ${POCOCAPSULE_BIN_DIR}/pxgenproxy${POCO_EXE_EXT})
endif()

if(POCO_PXENCODE_BINARY AND NOT TARGET PocoCapsule::pxencode)
    message(NOTICE "Found pxencode: ${POCO_PXENCODE_BINARY}")
    add_executable(PocoCapsule::pxencode IMPORTED)
    set_target_properties(
        PocoCapsule::pxencode
        PROPERTIES
            IMPORTED_LOCATION ${POCO_PXENCODE_BINARY}
    )
else()
    message(WARNING "pxencode binary not found")
endif()

if(POCO_PXGENPROXY_BINARY AND NOT TARGET PocoCapsule::pxgenproxy)
    message(NOTICE "Found pxgenproxy: ${POCO_PXGENPROXY_BINARY}")
    add_executable(PocoCapsule::pxgenproxy IMPORTED)
    set_target_properties(
        PocoCapsule::pxgenproxy
        PROPERTIES
            IMPORTED_LOCATION ${POCO_PXGENPROXY_BINARY}
    )
else()
    message(WARNING "pxgenproxy binary not found")
endif()
