# GRPC GYP build file

# This file has been automatically generated from a template file.
# Please look at the templates directory instead.
# This file can be regenerated from the template by running
# tools/buildgen/generate_projects.sh

# Copyright 2015 gRPC authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

{
  'variables': {
   # The openssl and zlib dependencies must be passed in as variables
   # defined in an included gypi file, usually common.gypi.
   'openssl_gyp_target%': 'Please Define openssl_gyp_target variable',
   'zlib_gyp_target%': 'Please Define zlib_gyp_target variable',

   'grpc_gcov%': 'false',
   'grpc_alpine%': 'false',
  },
  'target_defaults': {
    'configurations': {
      'Debug': {
        'cflags': [
          '-O0',
        ],
        'defines': [
          '_DEBUG',
          'DEBUG',
        ],
      },
      'Release': {
        'cflags': [
          '-O2',
          '-Wframe-larger-than=16384',
        ],
        'defines': [
          'NDEBUG',
        ],
      },
    },
    'cflags': [
      '-g',
      '-Wall',
      '-Wextra',
      '-DOSATOMIC_USE_INLINED=1',
      '-Ithird_party/abseil-cpp',
      '-Ithird_party/re2',
      '-Ithird_party/upb',
      '-Isrc/core/ext/upb-generated',
      '-Isrc/core/ext/upbdefs-generated',
      '-Ithird_party/xxhash',
    ],
    'ldflags': [
      '-g',
    ],
    'cflags_c': [
      '-Werror',
      '-std=c11',
    ],
    'cflags_cc': [
      '-Werror',
      '-std=c++14',
    ],
    'include_dirs': [
      '.',
      '../..',
      'include',
    ],
    'defines': [
      'GRPC_ARES=0',
    ],
    'dependencies': [
      '<(openssl_gyp_target)',
      '<(zlib_gyp_target)',
    ],
    'conditions': [
      ['grpc_gcov=="true"', {
        'cflags': [
          '-O0',
          '-fprofile-arcs',
          '-ftest-coverage',
          '-Wno-return-type',
        ],
        'defines': [
          '_DEBUG',
          'DEBUG',
          'GPR_GCOV',
        ],
        'ldflags': [
          '-fprofile-arcs',
          '-ftest-coverage',
          '-rdynamic',
          '-lstdc++',
        ],
      }],
      ['grpc_alpine=="true"', {
        'defines': [
          'GPR_MUSL_LIBC_COMPAT'
        ]
      }],
      ['OS == "win"', {
        'defines': [
          '_WIN32_WINNT=0x0600',
          'WIN32_LEAN_AND_MEAN',
          '_HAS_EXCEPTIONS=0',
          'UNICODE',
          '_UNICODE',
          'NOMINMAX',
        ],
        'msvs_settings': {
          'VCCLCompilerTool': {
            'RuntimeLibrary': 1, # static debug
          }
        },
        "libraries": [
          "ws2_32"
        ]
      }],
      ['OS == "mac"', {
        'xcode_settings': {
          'OTHER_CFLAGS': [
            '-g',
            '-Wall',
            '-Wextra',
            '-DOSATOMIC_USE_INLINED=1',
            '-Ithird_party/abseil-cpp',
            '-Ithird_party/re2',
            '-Ithird_party/upb',
            '-Isrc/core/ext/upb-generated',
            '-Isrc/core/ext/upbdefs-generated',
            '-Ithird_party/xxhash',
          ],
          'OTHER_CPLUSPLUSFLAGS': [
            '-g',
            '-Wall',
            '-Wextra',
            '-DOSATOMIC_USE_INLINED=1',
            '-Ithird_party/abseil-cpp',
            '-Ithird_party/re2',
            '-Ithird_party/upb',
            '-Isrc/core/ext/upb-generated',
            '-Isrc/core/ext/upbdefs-generated',
            '-Ithird_party/xxhash',
            '-stdlib=libc++',
            '-std=c++14',
            '-Wno-error=deprecated-declarations',
          ],
        },
      }]
    ]
  },
  'targets': [
    {
      'target_name': 'address_sorting',
      'type': 'static_library',
      'dependencies': [
      ],
      'sources': [
        'third_party/address_sorting/address_sorting.c',
        'third_party/address_sorting/address_sorting_posix.c',
        'third_party/address_sorting/address_sorting_windows.c',
      ],
    },
    {
      'target_name': 'end2end_tests',
      'type': 'static_library',
      'dependencies': [
        'grpc_test_util',
      ],
      'sources': [
        'src/core/lib/security/authorization/grpc_authorization_policy_provider.cc',
        'src/core/lib/security/authorization/rbac_translator.cc',
        'test/core/compression/args_utils.cc',
        'test/core/end2end/cq_verifier.cc',
        'test/core/end2end/data/client_certs.cc',
        'test/core/end2end/data/server1_cert.cc',
        'test/core/end2end/data/server1_key.cc',
        'test/core/end2end/data/test_root_cert.cc',
        'test/core/end2end/end2end_test_utils.cc',
        'test/core/end2end/end2end_tests.cc',
        'test/core/end2end/fixtures/http_proxy_fixture.cc',
        'test/core/end2end/fixtures/local_util.cc',
        'test/core/end2end/fixtures/proxy.cc',
        'test/core/end2end/tests/authority_not_supported.cc',
        'test/core/end2end/tests/bad_hostname.cc',
        'test/core/end2end/tests/bad_ping.cc',
        'test/core/end2end/tests/binary_metadata.cc',
        'test/core/end2end/tests/call_creds.cc',
        'test/core/end2end/tests/call_host_override.cc',
        'test/core/end2end/tests/cancel_after_accept.cc',
        'test/core/end2end/tests/cancel_after_client_done.cc',
        'test/core/end2end/tests/cancel_after_invoke.cc',
        'test/core/end2end/tests/cancel_after_round_trip.cc',
        'test/core/end2end/tests/cancel_before_invoke.cc',
        'test/core/end2end/tests/cancel_in_a_vacuum.cc',
        'test/core/end2end/tests/cancel_with_status.cc',
        'test/core/end2end/tests/channelz.cc',
        'test/core/end2end/tests/client_streaming.cc',
        'test/core/end2end/tests/compressed_payload.cc',
        'test/core/end2end/tests/connectivity.cc',
        'test/core/end2end/tests/default_host.cc',
        'test/core/end2end/tests/disappearing_server.cc',
        'test/core/end2end/tests/empty_batch.cc',
        'test/core/end2end/tests/filter_causes_close.cc',
        'test/core/end2end/tests/filter_context.cc',
        'test/core/end2end/tests/filter_init_fails.cc',
        'test/core/end2end/tests/filter_latency.cc',
        'test/core/end2end/tests/filter_status_code.cc',
        'test/core/end2end/tests/filtered_metadata.cc',
        'test/core/end2end/tests/graceful_server_shutdown.cc',
        'test/core/end2end/tests/grpc_authz.cc',
        'test/core/end2end/tests/high_initial_seqno.cc',
        'test/core/end2end/tests/hpack_size.cc',
        'test/core/end2end/tests/invoke_large_request.cc',
        'test/core/end2end/tests/keepalive_timeout.cc',
        'test/core/end2end/tests/large_metadata.cc',
        'test/core/end2end/tests/max_concurrent_streams.cc',
        'test/core/end2end/tests/max_connection_age.cc',
        'test/core/end2end/tests/max_connection_idle.cc',
        'test/core/end2end/tests/max_message_length.cc',
        'test/core/end2end/tests/negative_deadline.cc',
        'test/core/end2end/tests/no_error_on_hotpath.cc',
        'test/core/end2end/tests/no_logging.cc',
        'test/core/end2end/tests/no_op.cc',
        'test/core/end2end/tests/payload.cc',
        'test/core/end2end/tests/ping.cc',
        'test/core/end2end/tests/ping_pong_streaming.cc',
        'test/core/end2end/tests/proxy_auth.cc',
        'test/core/end2end/tests/registered_call.cc',
        'test/core/end2end/tests/request_with_flags.cc',
        'test/core/end2end/tests/request_with_payload.cc',
        'test/core/end2end/tests/resource_quota_server.cc',
        'test/core/end2end/tests/retry.cc',
        'test/core/end2end/tests/retry_cancel_after_first_attempt_starts.cc',
        'test/core/end2end/tests/retry_cancel_during_delay.cc',
        'test/core/end2end/tests/retry_cancel_with_multiple_send_batches.cc',
        'test/core/end2end/tests/retry_cancellation.cc',
        'test/core/end2end/tests/retry_disabled.cc',
        'test/core/end2end/tests/retry_exceeds_buffer_size_in_delay.cc',
        'test/core/end2end/tests/retry_exceeds_buffer_size_in_initial_batch.cc',
        'test/core/end2end/tests/retry_exceeds_buffer_size_in_subsequent_batch.cc',
        'test/core/end2end/tests/retry_lb_drop.cc',
        'test/core/end2end/tests/retry_lb_fail.cc',
        'test/core/end2end/tests/retry_non_retriable_status.cc',
        'test/core/end2end/tests/retry_non_retriable_status_before_recv_trailing_metadata_started.cc',
        'test/core/end2end/tests/retry_per_attempt_recv_timeout.cc',
        'test/core/end2end/tests/retry_per_attempt_recv_timeout_on_last_attempt.cc',
        'test/core/end2end/tests/retry_recv_initial_metadata.cc',
        'test/core/end2end/tests/retry_recv_message.cc',
        'test/core/end2end/tests/retry_recv_message_replay.cc',
        'test/core/end2end/tests/retry_recv_trailing_metadata_error.cc',
        'test/core/end2end/tests/retry_send_initial_metadata_refs.cc',
        'test/core/end2end/tests/retry_send_op_fails.cc',
        'test/core/end2end/tests/retry_send_recv_batch.cc',
        'test/core/end2end/tests/retry_server_pushback_delay.cc',
        'test/core/end2end/tests/retry_server_pushback_disabled.cc',
        'test/core/end2end/tests/retry_streaming.cc',
        'test/core/end2end/tests/retry_streaming_after_commit.cc',
        'test/core/end2end/tests/retry_streaming_succeeds_before_replay_finished.cc',
        'test/core/end2end/tests/retry_throttled.cc',
        'test/core/end2end/tests/retry_too_many_attempts.cc',
        'test/core/end2end/tests/retry_transparent_goaway.cc',
        'test/core/end2end/tests/retry_transparent_max_concurrent_streams.cc',
        'test/core/end2end/tests/retry_transparent_not_sent_on_wire.cc',
        'test/core/end2end/tests/retry_unref_before_finish.cc',
        'test/core/end2end/tests/retry_unref_before_recv.cc',
        'test/core/end2end/tests/server_finishes_request.cc',
        'test/core/end2end/tests/server_streaming.cc',
        'test/core/end2end/tests/shutdown_finishes_calls.cc',
        'test/core/end2end/tests/shutdown_finishes_tags.cc',
        'test/core/end2end/tests/simple_delayed_request.cc',
        'test/core/end2end/tests/simple_metadata.cc',
        'test/core/end2end/tests/simple_request.cc',
        'test/core/end2end/tests/streaming_error_response.cc',
        'test/core/end2end/tests/trailing_metadata.cc',
        'test/core/end2end/tests/write_buffering.cc',
        'test/core/end2end/tests/write_buffering_at_end.cc',
        'test/core/util/test_lb_policies.cc',
      ],
    },
    {
      'target_name': 'gpr',
      'type': 'static_library',
      'dependencies': [
        'absl/base:base',
        'absl/base:core_headers',
        'absl/memory:memory',
        'absl/random:random',
        'absl/status:status',
        'absl/strings:cord',
        'absl/strings:str_format',
        'absl/strings:strings',
        'absl/synchronization:synchronization',
        'absl/time:time',
        'absl/types:optional',
        'absl/types:variant',
      ],
      'sources': [
        'src/core/lib/gpr/alloc.cc',
        'src/core/lib/gpr/atm.cc',
        'src/core/lib/gpr/cpu_iphone.cc',
        'src/core/lib/gpr/cpu_linux.cc',
        'src/core/lib/gpr/cpu_posix.cc',
        'src/core/lib/gpr/cpu_windows.cc',
        'src/core/lib/gpr/log.cc',
        'src/core/lib/gpr/log_android.cc',
        'src/core/lib/gpr/log_linux.cc',
        'src/core/lib/gpr/log_posix.cc',
        'src/core/lib/gpr/log_windows.cc',
        'src/core/lib/gpr/string.cc',
        'src/core/lib/gpr/string_posix.cc',
        'src/core/lib/gpr/string_util_windows.cc',
        'src/core/lib/gpr/string_windows.cc',
        'src/core/lib/gpr/sync.cc',
        'src/core/lib/gpr/sync_abseil.cc',
        'src/core/lib/gpr/sync_posix.cc',
        'src/core/lib/gpr/sync_windows.cc',
        'src/core/lib/gpr/time.cc',
        'src/core/lib/gpr/time_posix.cc',
        'src/core/lib/gpr/time_precise.cc',
        'src/core/lib/gpr/time_windows.cc',
        'src/core/lib/gpr/tmpfile_msys.cc',
        'src/core/lib/gpr/tmpfile_posix.cc',
        'src/core/lib/gpr/tmpfile_windows.cc',
        'src/core/lib/gpr/wrap_memcpy.cc',
        'src/core/lib/gprpp/env_linux.cc',
        'src/core/lib/gprpp/env_posix.cc',
        'src/core/lib/gprpp/env_windows.cc',
        'src/core/lib/gprpp/examine_stack.cc',
        'src/core/lib/gprpp/fork.cc',
        'src/core/lib/gprpp/global_config_env.cc',
        'src/core/lib/gprpp/host_port.cc',
        'src/core/lib/gprpp/mpscq.cc',
        'src/core/lib/gprpp/stat_posix.cc',
        'src/core/lib/gprpp/stat_windows.cc',
        'src/core/lib/gprpp/tchar.cc',
        'src/core/lib/gprpp/thd_posix.cc',
        'src/core/lib/gprpp/thd_windows.cc',
        'src/core/lib/gprpp/time_util.cc',
      ],
    },
    {
      'target_name': 'grpc',
      'type': 'static_library',
      'dependencies': [
        'absl/container:flat_hash_map',
        'absl/container:flat_hash_set',
        'absl/container:inlined_vector',
        'absl/functional:any_invocable',
        'absl/functional:bind_front',
        'absl/functional:function_ref',
        'absl/hash:hash',
        'absl/meta:type_traits',
        'absl/status:statusor',
        'absl/types:span',
        'absl/utility:utility',
        'gpr',
        'address_sorting',
        'upb',
      ],
      'sources': [
        'src/core/ext/filters/census/grpc_context.cc',
        'src/core/ext/filters/channel_idle/channel_idle_filter.cc',
        'src/core/ext/filters/channel_idle/idle_filter_state.cc',
        'src/core/ext/filters/client_channel/backend_metric.cc',
        'src/core/ext/filters/client_channel/backup_poller.cc',
        'src/core/ext/filters/client_channel/channel_connectivity.cc',
        'src/core/ext/filters/client_channel/client_channel.cc',
        'src/core/ext/filters/client_channel/client_channel_channelz.cc',
        'src/core/ext/filters/client_channel/client_channel_factory.cc',
        'src/core/ext/filters/client_channel/client_channel_plugin.cc',
        'src/core/ext/filters/client_channel/config_selector.cc',
        'src/core/ext/filters/client_channel/dynamic_filters.cc',
        'src/core/ext/filters/client_channel/global_subchannel_pool.cc',
        'src/core/ext/filters/client_channel/health/health_check_client.cc',
        'src/core/ext/filters/client_channel/http_proxy.cc',
        'src/core/ext/filters/client_channel/lb_policy/address_filtering.cc',
        'src/core/ext/filters/client_channel/lb_policy/child_policy_handler.cc',
        'src/core/ext/filters/client_channel/lb_policy/grpclb/client_load_reporting_filter.cc',
        'src/core/ext/filters/client_channel/lb_policy/grpclb/grpclb.cc',
        'src/core/ext/filters/client_channel/lb_policy/grpclb/grpclb_balancer_addresses.cc',
        'src/core/ext/filters/client_channel/lb_policy/grpclb/grpclb_client_stats.cc',
        'src/core/ext/filters/client_channel/lb_policy/grpclb/load_balancer_api.cc',
        'src/core/ext/filters/client_channel/lb_policy/oob_backend_metric.cc',
        'src/core/ext/filters/client_channel/lb_policy/outlier_detection/outlier_detection.cc',
        'src/core/ext/filters/client_channel/lb_policy/pick_first/pick_first.cc',
        'src/core/ext/filters/client_channel/lb_policy/priority/priority.cc',
        'src/core/ext/filters/client_channel/lb_policy/ring_hash/ring_hash.cc',
        'src/core/ext/filters/client_channel/lb_policy/rls/rls.cc',
        'src/core/ext/filters/client_channel/lb_policy/round_robin/round_robin.cc',
        'src/core/ext/filters/client_channel/lb_policy/weighted_target/weighted_target.cc',
        'src/core/ext/filters/client_channel/lb_policy/xds/cds.cc',
        'src/core/ext/filters/client_channel/lb_policy/xds/xds_cluster_impl.cc',
        'src/core/ext/filters/client_channel/lb_policy/xds/xds_cluster_manager.cc',
        'src/core/ext/filters/client_channel/lb_policy/xds/xds_cluster_resolver.cc',
        'src/core/ext/filters/client_channel/local_subchannel_pool.cc',
        'src/core/ext/filters/client_channel/resolver/binder/binder_resolver.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/dns_resolver_ares.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_ev_driver_posix.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_ev_driver_windows.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_wrapper.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_wrapper_posix.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_wrapper_windows.cc',
        'src/core/ext/filters/client_channel/resolver/dns/dns_resolver_selection.cc',
        'src/core/ext/filters/client_channel/resolver/dns/native/dns_resolver.cc',
        'src/core/ext/filters/client_channel/resolver/fake/fake_resolver.cc',
        'src/core/ext/filters/client_channel/resolver/google_c2p/google_c2p_resolver.cc',
        'src/core/ext/filters/client_channel/resolver/polling_resolver.cc',
        'src/core/ext/filters/client_channel/resolver/sockaddr/sockaddr_resolver.cc',
        'src/core/ext/filters/client_channel/resolver/xds/xds_resolver.cc',
        'src/core/ext/filters/client_channel/resolver_result_parsing.cc',
        'src/core/ext/filters/client_channel/retry_filter.cc',
        'src/core/ext/filters/client_channel/retry_service_config.cc',
        'src/core/ext/filters/client_channel/retry_throttle.cc',
        'src/core/ext/filters/client_channel/service_config_channel_arg_filter.cc',
        'src/core/ext/filters/client_channel/subchannel.cc',
        'src/core/ext/filters/client_channel/subchannel_pool_interface.cc',
        'src/core/ext/filters/client_channel/subchannel_stream_client.cc',
        'src/core/ext/filters/deadline/deadline_filter.cc',
        'src/core/ext/filters/fault_injection/fault_injection_filter.cc',
        'src/core/ext/filters/fault_injection/service_config_parser.cc',
        'src/core/ext/filters/http/client/http_client_filter.cc',
        'src/core/ext/filters/http/client_authority_filter.cc',
        'src/core/ext/filters/http/http_filters_plugin.cc',
        'src/core/ext/filters/http/message_compress/message_compress_filter.cc',
        'src/core/ext/filters/http/message_compress/message_decompress_filter.cc',
        'src/core/ext/filters/http/server/http_server_filter.cc',
        'src/core/ext/filters/message_size/message_size_filter.cc',
        'src/core/ext/filters/rbac/rbac_filter.cc',
        'src/core/ext/filters/rbac/rbac_service_config_parser.cc',
        'src/core/ext/filters/server_config_selector/server_config_selector.cc',
        'src/core/ext/filters/server_config_selector/server_config_selector_filter.cc',
        'src/core/ext/transport/chttp2/alpn/alpn.cc',
        'src/core/ext/transport/chttp2/client/chttp2_connector.cc',
        'src/core/ext/transport/chttp2/server/chttp2_server.cc',
        'src/core/ext/transport/chttp2/transport/bin_decoder.cc',
        'src/core/ext/transport/chttp2/transport/bin_encoder.cc',
        'src/core/ext/transport/chttp2/transport/chttp2_transport.cc',
        'src/core/ext/transport/chttp2/transport/context_list.cc',
        'src/core/ext/transport/chttp2/transport/decode_huff.cc',
        'src/core/ext/transport/chttp2/transport/flow_control.cc',
        'src/core/ext/transport/chttp2/transport/frame_data.cc',
        'src/core/ext/transport/chttp2/transport/frame_goaway.cc',
        'src/core/ext/transport/chttp2/transport/frame_ping.cc',
        'src/core/ext/transport/chttp2/transport/frame_rst_stream.cc',
        'src/core/ext/transport/chttp2/transport/frame_settings.cc',
        'src/core/ext/transport/chttp2/transport/frame_window_update.cc',
        'src/core/ext/transport/chttp2/transport/hpack_encoder.cc',
        'src/core/ext/transport/chttp2/transport/hpack_encoder_table.cc',
        'src/core/ext/transport/chttp2/transport/hpack_parser.cc',
        'src/core/ext/transport/chttp2/transport/hpack_parser_table.cc',
        'src/core/ext/transport/chttp2/transport/http2_settings.cc',
        'src/core/ext/transport/chttp2/transport/huffsyms.cc',
        'src/core/ext/transport/chttp2/transport/parsing.cc',
        'src/core/ext/transport/chttp2/transport/stream_lists.cc',
        'src/core/ext/transport/chttp2/transport/stream_map.cc',
        'src/core/ext/transport/chttp2/transport/varint.cc',
        'src/core/ext/transport/chttp2/transport/writing.cc',
        'src/core/ext/transport/inproc/inproc_plugin.cc',
        'src/core/ext/transport/inproc/inproc_transport.cc',
        'src/core/ext/upb-generated/envoy/admin/v3/certs.upb.c',
        'src/core/ext/upb-generated/envoy/admin/v3/clusters.upb.c',
        'src/core/ext/upb-generated/envoy/admin/v3/config_dump.upb.c',
        'src/core/ext/upb-generated/envoy/admin/v3/config_dump_shared.upb.c',
        'src/core/ext/upb-generated/envoy/admin/v3/init_dump.upb.c',
        'src/core/ext/upb-generated/envoy/admin/v3/listeners.upb.c',
        'src/core/ext/upb-generated/envoy/admin/v3/memory.upb.c',
        'src/core/ext/upb-generated/envoy/admin/v3/metrics.upb.c',
        'src/core/ext/upb-generated/envoy/admin/v3/mutex_stats.upb.c',
        'src/core/ext/upb-generated/envoy/admin/v3/server_info.upb.c',
        'src/core/ext/upb-generated/envoy/admin/v3/tap.upb.c',
        'src/core/ext/upb-generated/envoy/annotations/deprecation.upb.c',
        'src/core/ext/upb-generated/envoy/annotations/resource.upb.c',
        'src/core/ext/upb-generated/envoy/config/accesslog/v3/accesslog.upb.c',
        'src/core/ext/upb-generated/envoy/config/bootstrap/v3/bootstrap.upb.c',
        'src/core/ext/upb-generated/envoy/config/cluster/v3/circuit_breaker.upb.c',
        'src/core/ext/upb-generated/envoy/config/cluster/v3/cluster.upb.c',
        'src/core/ext/upb-generated/envoy/config/cluster/v3/filter.upb.c',
        'src/core/ext/upb-generated/envoy/config/cluster/v3/outlier_detection.upb.c',
        'src/core/ext/upb-generated/envoy/config/common/matcher/v3/matcher.upb.c',
        'src/core/ext/upb-generated/envoy/config/core/v3/address.upb.c',
        'src/core/ext/upb-generated/envoy/config/core/v3/backoff.upb.c',
        'src/core/ext/upb-generated/envoy/config/core/v3/base.upb.c',
        'src/core/ext/upb-generated/envoy/config/core/v3/config_source.upb.c',
        'src/core/ext/upb-generated/envoy/config/core/v3/event_service_config.upb.c',
        'src/core/ext/upb-generated/envoy/config/core/v3/extension.upb.c',
        'src/core/ext/upb-generated/envoy/config/core/v3/grpc_method_list.upb.c',
        'src/core/ext/upb-generated/envoy/config/core/v3/grpc_service.upb.c',
        'src/core/ext/upb-generated/envoy/config/core/v3/health_check.upb.c',
        'src/core/ext/upb-generated/envoy/config/core/v3/http_uri.upb.c',
        'src/core/ext/upb-generated/envoy/config/core/v3/protocol.upb.c',
        'src/core/ext/upb-generated/envoy/config/core/v3/proxy_protocol.upb.c',
        'src/core/ext/upb-generated/envoy/config/core/v3/resolver.upb.c',
        'src/core/ext/upb-generated/envoy/config/core/v3/socket_option.upb.c',
        'src/core/ext/upb-generated/envoy/config/core/v3/substitution_format_string.upb.c',
        'src/core/ext/upb-generated/envoy/config/core/v3/udp_socket_config.upb.c',
        'src/core/ext/upb-generated/envoy/config/endpoint/v3/endpoint.upb.c',
        'src/core/ext/upb-generated/envoy/config/endpoint/v3/endpoint_components.upb.c',
        'src/core/ext/upb-generated/envoy/config/endpoint/v3/load_report.upb.c',
        'src/core/ext/upb-generated/envoy/config/listener/v3/api_listener.upb.c',
        'src/core/ext/upb-generated/envoy/config/listener/v3/listener.upb.c',
        'src/core/ext/upb-generated/envoy/config/listener/v3/listener_components.upb.c',
        'src/core/ext/upb-generated/envoy/config/listener/v3/quic_config.upb.c',
        'src/core/ext/upb-generated/envoy/config/listener/v3/udp_listener_config.upb.c',
        'src/core/ext/upb-generated/envoy/config/metrics/v3/metrics_service.upb.c',
        'src/core/ext/upb-generated/envoy/config/metrics/v3/stats.upb.c',
        'src/core/ext/upb-generated/envoy/config/overload/v3/overload.upb.c',
        'src/core/ext/upb-generated/envoy/config/rbac/v3/rbac.upb.c',
        'src/core/ext/upb-generated/envoy/config/route/v3/route.upb.c',
        'src/core/ext/upb-generated/envoy/config/route/v3/route_components.upb.c',
        'src/core/ext/upb-generated/envoy/config/route/v3/scoped_route.upb.c',
        'src/core/ext/upb-generated/envoy/config/tap/v3/common.upb.c',
        'src/core/ext/upb-generated/envoy/config/trace/v3/datadog.upb.c',
        'src/core/ext/upb-generated/envoy/config/trace/v3/dynamic_ot.upb.c',
        'src/core/ext/upb-generated/envoy/config/trace/v3/http_tracer.upb.c',
        'src/core/ext/upb-generated/envoy/config/trace/v3/lightstep.upb.c',
        'src/core/ext/upb-generated/envoy/config/trace/v3/opencensus.upb.c',
        'src/core/ext/upb-generated/envoy/config/trace/v3/opentelemetry.upb.c',
        'src/core/ext/upb-generated/envoy/config/trace/v3/service.upb.c',
        'src/core/ext/upb-generated/envoy/config/trace/v3/skywalking.upb.c',
        'src/core/ext/upb-generated/envoy/config/trace/v3/trace.upb.c',
        'src/core/ext/upb-generated/envoy/config/trace/v3/xray.upb.c',
        'src/core/ext/upb-generated/envoy/config/trace/v3/zipkin.upb.c',
        'src/core/ext/upb-generated/envoy/extensions/clusters/aggregate/v3/cluster.upb.c',
        'src/core/ext/upb-generated/envoy/extensions/filters/common/fault/v3/fault.upb.c',
        'src/core/ext/upb-generated/envoy/extensions/filters/http/fault/v3/fault.upb.c',
        'src/core/ext/upb-generated/envoy/extensions/filters/http/rbac/v3/rbac.upb.c',
        'src/core/ext/upb-generated/envoy/extensions/filters/http/router/v3/router.upb.c',
        'src/core/ext/upb-generated/envoy/extensions/filters/network/http_connection_manager/v3/http_connection_manager.upb.c',
        'src/core/ext/upb-generated/envoy/extensions/load_balancing_policies/ring_hash/v3/ring_hash.upb.c',
        'src/core/ext/upb-generated/envoy/extensions/load_balancing_policies/wrr_locality/v3/wrr_locality.upb.c',
        'src/core/ext/upb-generated/envoy/extensions/transport_sockets/tls/v3/cert.upb.c',
        'src/core/ext/upb-generated/envoy/extensions/transport_sockets/tls/v3/common.upb.c',
        'src/core/ext/upb-generated/envoy/extensions/transport_sockets/tls/v3/secret.upb.c',
        'src/core/ext/upb-generated/envoy/extensions/transport_sockets/tls/v3/tls.upb.c',
        'src/core/ext/upb-generated/envoy/extensions/transport_sockets/tls/v3/tls_spiffe_validator_config.upb.c',
        'src/core/ext/upb-generated/envoy/service/discovery/v3/ads.upb.c',
        'src/core/ext/upb-generated/envoy/service/discovery/v3/discovery.upb.c',
        'src/core/ext/upb-generated/envoy/service/load_stats/v3/lrs.upb.c',
        'src/core/ext/upb-generated/envoy/service/status/v3/csds.upb.c',
        'src/core/ext/upb-generated/envoy/type/http/v3/cookie.upb.c',
        'src/core/ext/upb-generated/envoy/type/http/v3/path_transformation.upb.c',
        'src/core/ext/upb-generated/envoy/type/matcher/v3/http_inputs.upb.c',
        'src/core/ext/upb-generated/envoy/type/matcher/v3/metadata.upb.c',
        'src/core/ext/upb-generated/envoy/type/matcher/v3/node.upb.c',
        'src/core/ext/upb-generated/envoy/type/matcher/v3/number.upb.c',
        'src/core/ext/upb-generated/envoy/type/matcher/v3/path.upb.c',
        'src/core/ext/upb-generated/envoy/type/matcher/v3/regex.upb.c',
        'src/core/ext/upb-generated/envoy/type/matcher/v3/string.upb.c',
        'src/core/ext/upb-generated/envoy/type/matcher/v3/struct.upb.c',
        'src/core/ext/upb-generated/envoy/type/matcher/v3/value.upb.c',
        'src/core/ext/upb-generated/envoy/type/metadata/v3/metadata.upb.c',
        'src/core/ext/upb-generated/envoy/type/tracing/v3/custom_tag.upb.c',
        'src/core/ext/upb-generated/envoy/type/v3/hash_policy.upb.c',
        'src/core/ext/upb-generated/envoy/type/v3/http.upb.c',
        'src/core/ext/upb-generated/envoy/type/v3/http_status.upb.c',
        'src/core/ext/upb-generated/envoy/type/v3/percent.upb.c',
        'src/core/ext/upb-generated/envoy/type/v3/range.upb.c',
        'src/core/ext/upb-generated/envoy/type/v3/ratelimit_strategy.upb.c',
        'src/core/ext/upb-generated/envoy/type/v3/ratelimit_unit.upb.c',
        'src/core/ext/upb-generated/envoy/type/v3/semantic_version.upb.c',
        'src/core/ext/upb-generated/envoy/type/v3/token_bucket.upb.c',
        'src/core/ext/upb-generated/google/api/annotations.upb.c',
        'src/core/ext/upb-generated/google/api/expr/v1alpha1/checked.upb.c',
        'src/core/ext/upb-generated/google/api/expr/v1alpha1/syntax.upb.c',
        'src/core/ext/upb-generated/google/api/http.upb.c',
        'src/core/ext/upb-generated/google/api/httpbody.upb.c',
        'src/core/ext/upb-generated/google/protobuf/any.upb.c',
        'src/core/ext/upb-generated/google/protobuf/descriptor.upb.c',
        'src/core/ext/upb-generated/google/protobuf/duration.upb.c',
        'src/core/ext/upb-generated/google/protobuf/empty.upb.c',
        'src/core/ext/upb-generated/google/protobuf/struct.upb.c',
        'src/core/ext/upb-generated/google/protobuf/timestamp.upb.c',
        'src/core/ext/upb-generated/google/protobuf/wrappers.upb.c',
        'src/core/ext/upb-generated/google/rpc/status.upb.c',
        'src/core/ext/upb-generated/opencensus/proto/trace/v1/trace_config.upb.c',
        'src/core/ext/upb-generated/src/proto/grpc/gcp/altscontext.upb.c',
        'src/core/ext/upb-generated/src/proto/grpc/gcp/handshaker.upb.c',
        'src/core/ext/upb-generated/src/proto/grpc/gcp/transport_security_common.upb.c',
        'src/core/ext/upb-generated/src/proto/grpc/health/v1/health.upb.c',
        'src/core/ext/upb-generated/src/proto/grpc/lb/v1/load_balancer.upb.c',
        'src/core/ext/upb-generated/src/proto/grpc/lookup/v1/rls.upb.c',
        'src/core/ext/upb-generated/src/proto/grpc/lookup/v1/rls_config.upb.c',
        'src/core/ext/upb-generated/udpa/annotations/migrate.upb.c',
        'src/core/ext/upb-generated/udpa/annotations/security.upb.c',
        'src/core/ext/upb-generated/udpa/annotations/sensitive.upb.c',
        'src/core/ext/upb-generated/udpa/annotations/status.upb.c',
        'src/core/ext/upb-generated/udpa/annotations/versioning.upb.c',
        'src/core/ext/upb-generated/validate/validate.upb.c',
        'src/core/ext/upb-generated/xds/annotations/v3/migrate.upb.c',
        'src/core/ext/upb-generated/xds/annotations/v3/security.upb.c',
        'src/core/ext/upb-generated/xds/annotations/v3/sensitive.upb.c',
        'src/core/ext/upb-generated/xds/annotations/v3/status.upb.c',
        'src/core/ext/upb-generated/xds/annotations/v3/versioning.upb.c',
        'src/core/ext/upb-generated/xds/core/v3/authority.upb.c',
        'src/core/ext/upb-generated/xds/core/v3/collection_entry.upb.c',
        'src/core/ext/upb-generated/xds/core/v3/context_params.upb.c',
        'src/core/ext/upb-generated/xds/core/v3/extension.upb.c',
        'src/core/ext/upb-generated/xds/core/v3/resource.upb.c',
        'src/core/ext/upb-generated/xds/core/v3/resource_locator.upb.c',
        'src/core/ext/upb-generated/xds/core/v3/resource_name.upb.c',
        'src/core/ext/upb-generated/xds/data/orca/v3/orca_load_report.upb.c',
        'src/core/ext/upb-generated/xds/service/orca/v3/orca.upb.c',
        'src/core/ext/upb-generated/xds/type/matcher/v3/matcher.upb.c',
        'src/core/ext/upb-generated/xds/type/matcher/v3/regex.upb.c',
        'src/core/ext/upb-generated/xds/type/matcher/v3/string.upb.c',
        'src/core/ext/upb-generated/xds/type/v3/typed_struct.upb.c',
        'src/core/ext/upbdefs-generated/envoy/admin/v3/certs.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/admin/v3/clusters.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/admin/v3/config_dump.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/admin/v3/config_dump_shared.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/admin/v3/init_dump.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/admin/v3/listeners.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/admin/v3/memory.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/admin/v3/metrics.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/admin/v3/mutex_stats.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/admin/v3/server_info.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/admin/v3/tap.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/annotations/deprecation.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/annotations/resource.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/accesslog/v3/accesslog.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/bootstrap/v3/bootstrap.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/cluster/v3/circuit_breaker.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/cluster/v3/cluster.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/cluster/v3/filter.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/cluster/v3/outlier_detection.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/common/matcher/v3/matcher.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/core/v3/address.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/core/v3/backoff.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/core/v3/base.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/core/v3/config_source.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/core/v3/event_service_config.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/core/v3/extension.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/core/v3/grpc_method_list.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/core/v3/grpc_service.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/core/v3/health_check.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/core/v3/http_uri.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/core/v3/protocol.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/core/v3/proxy_protocol.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/core/v3/resolver.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/core/v3/socket_option.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/core/v3/substitution_format_string.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/core/v3/udp_socket_config.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/endpoint/v3/endpoint.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/endpoint/v3/endpoint_components.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/endpoint/v3/load_report.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/listener/v3/api_listener.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/listener/v3/listener.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/listener/v3/listener_components.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/listener/v3/quic_config.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/listener/v3/udp_listener_config.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/metrics/v3/metrics_service.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/metrics/v3/stats.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/overload/v3/overload.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/rbac/v3/rbac.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/route/v3/route.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/route/v3/route_components.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/route/v3/scoped_route.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/tap/v3/common.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/trace/v3/datadog.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/trace/v3/dynamic_ot.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/trace/v3/http_tracer.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/trace/v3/lightstep.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/trace/v3/opencensus.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/trace/v3/opentelemetry.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/trace/v3/service.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/trace/v3/skywalking.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/trace/v3/trace.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/trace/v3/xray.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/config/trace/v3/zipkin.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/extensions/clusters/aggregate/v3/cluster.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/extensions/filters/common/fault/v3/fault.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/extensions/filters/http/fault/v3/fault.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/extensions/filters/http/rbac/v3/rbac.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/extensions/filters/http/router/v3/router.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/extensions/filters/network/http_connection_manager/v3/http_connection_manager.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/extensions/transport_sockets/tls/v3/cert.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/extensions/transport_sockets/tls/v3/common.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/extensions/transport_sockets/tls/v3/secret.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/extensions/transport_sockets/tls/v3/tls.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/extensions/transport_sockets/tls/v3/tls_spiffe_validator_config.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/service/discovery/v3/ads.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/service/discovery/v3/discovery.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/service/load_stats/v3/lrs.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/service/status/v3/csds.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/type/http/v3/cookie.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/type/http/v3/path_transformation.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/type/matcher/v3/http_inputs.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/type/matcher/v3/metadata.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/type/matcher/v3/node.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/type/matcher/v3/number.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/type/matcher/v3/path.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/type/matcher/v3/regex.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/type/matcher/v3/string.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/type/matcher/v3/struct.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/type/matcher/v3/value.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/type/metadata/v3/metadata.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/type/tracing/v3/custom_tag.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/type/v3/hash_policy.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/type/v3/http.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/type/v3/http_status.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/type/v3/percent.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/type/v3/range.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/type/v3/ratelimit_strategy.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/type/v3/ratelimit_unit.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/type/v3/semantic_version.upbdefs.c',
        'src/core/ext/upbdefs-generated/envoy/type/v3/token_bucket.upbdefs.c',
        'src/core/ext/upbdefs-generated/google/api/annotations.upbdefs.c',
        'src/core/ext/upbdefs-generated/google/api/expr/v1alpha1/checked.upbdefs.c',
        'src/core/ext/upbdefs-generated/google/api/expr/v1alpha1/syntax.upbdefs.c',
        'src/core/ext/upbdefs-generated/google/api/http.upbdefs.c',
        'src/core/ext/upbdefs-generated/google/api/httpbody.upbdefs.c',
        'src/core/ext/upbdefs-generated/google/protobuf/any.upbdefs.c',
        'src/core/ext/upbdefs-generated/google/protobuf/descriptor.upbdefs.c',
        'src/core/ext/upbdefs-generated/google/protobuf/duration.upbdefs.c',
        'src/core/ext/upbdefs-generated/google/protobuf/empty.upbdefs.c',
        'src/core/ext/upbdefs-generated/google/protobuf/struct.upbdefs.c',
        'src/core/ext/upbdefs-generated/google/protobuf/timestamp.upbdefs.c',
        'src/core/ext/upbdefs-generated/google/protobuf/wrappers.upbdefs.c',
        'src/core/ext/upbdefs-generated/google/rpc/status.upbdefs.c',
        'src/core/ext/upbdefs-generated/opencensus/proto/trace/v1/trace_config.upbdefs.c',
        'src/core/ext/upbdefs-generated/src/proto/grpc/lookup/v1/rls_config.upbdefs.c',
        'src/core/ext/upbdefs-generated/udpa/annotations/migrate.upbdefs.c',
        'src/core/ext/upbdefs-generated/udpa/annotations/security.upbdefs.c',
        'src/core/ext/upbdefs-generated/udpa/annotations/sensitive.upbdefs.c',
        'src/core/ext/upbdefs-generated/udpa/annotations/status.upbdefs.c',
        'src/core/ext/upbdefs-generated/udpa/annotations/versioning.upbdefs.c',
        'src/core/ext/upbdefs-generated/validate/validate.upbdefs.c',
        'src/core/ext/upbdefs-generated/xds/annotations/v3/migrate.upbdefs.c',
        'src/core/ext/upbdefs-generated/xds/annotations/v3/security.upbdefs.c',
        'src/core/ext/upbdefs-generated/xds/annotations/v3/sensitive.upbdefs.c',
        'src/core/ext/upbdefs-generated/xds/annotations/v3/status.upbdefs.c',
        'src/core/ext/upbdefs-generated/xds/annotations/v3/versioning.upbdefs.c',
        'src/core/ext/upbdefs-generated/xds/core/v3/authority.upbdefs.c',
        'src/core/ext/upbdefs-generated/xds/core/v3/collection_entry.upbdefs.c',
        'src/core/ext/upbdefs-generated/xds/core/v3/context_params.upbdefs.c',
        'src/core/ext/upbdefs-generated/xds/core/v3/extension.upbdefs.c',
        'src/core/ext/upbdefs-generated/xds/core/v3/resource.upbdefs.c',
        'src/core/ext/upbdefs-generated/xds/core/v3/resource_locator.upbdefs.c',
        'src/core/ext/upbdefs-generated/xds/core/v3/resource_name.upbdefs.c',
        'src/core/ext/upbdefs-generated/xds/type/matcher/v3/matcher.upbdefs.c',
        'src/core/ext/upbdefs-generated/xds/type/matcher/v3/regex.upbdefs.c',
        'src/core/ext/upbdefs-generated/xds/type/matcher/v3/string.upbdefs.c',
        'src/core/ext/upbdefs-generated/xds/type/v3/typed_struct.upbdefs.c',
        'src/core/ext/xds/certificate_provider_store.cc',
        'src/core/ext/xds/file_watcher_certificate_provider_factory.cc',
        'src/core/ext/xds/xds_api.cc',
        'src/core/ext/xds/xds_bootstrap.cc',
        'src/core/ext/xds/xds_bootstrap_grpc.cc',
        'src/core/ext/xds/xds_certificate_provider.cc',
        'src/core/ext/xds/xds_channel_stack_modifier.cc',
        'src/core/ext/xds/xds_client.cc',
        'src/core/ext/xds/xds_client_grpc.cc',
        'src/core/ext/xds/xds_client_stats.cc',
        'src/core/ext/xds/xds_cluster.cc',
        'src/core/ext/xds/xds_cluster_specifier_plugin.cc',
        'src/core/ext/xds/xds_common_types.cc',
        'src/core/ext/xds/xds_endpoint.cc',
        'src/core/ext/xds/xds_http_fault_filter.cc',
        'src/core/ext/xds/xds_http_filters.cc',
        'src/core/ext/xds/xds_http_rbac_filter.cc',
        'src/core/ext/xds/xds_lb_policy_registry.cc',
        'src/core/ext/xds/xds_listener.cc',
        'src/core/ext/xds/xds_resource_type.cc',
        'src/core/ext/xds/xds_route_config.cc',
        'src/core/ext/xds/xds_routing.cc',
        'src/core/ext/xds/xds_server_config_fetcher.cc',
        'src/core/ext/xds/xds_transport_grpc.cc',
        'src/core/lib/address_utils/parse_address.cc',
        'src/core/lib/address_utils/sockaddr_utils.cc',
        'src/core/lib/backoff/backoff.cc',
        'src/core/lib/channel/channel_args.cc',
        'src/core/lib/channel/channel_args_preconditioning.cc',
        'src/core/lib/channel/channel_stack.cc',
        'src/core/lib/channel/channel_stack_builder.cc',
        'src/core/lib/channel/channel_stack_builder_impl.cc',
        'src/core/lib/channel/channel_trace.cc',
        'src/core/lib/channel/channelz.cc',
        'src/core/lib/channel/channelz_registry.cc',
        'src/core/lib/channel/connected_channel.cc',
        'src/core/lib/channel/promise_based_filter.cc',
        'src/core/lib/channel/status_util.cc',
        'src/core/lib/compression/compression.cc',
        'src/core/lib/compression/compression_internal.cc',
        'src/core/lib/compression/message_compress.cc',
        'src/core/lib/config/core_configuration.cc',
        'src/core/lib/debug/stats.cc',
        'src/core/lib/debug/stats_data.cc',
        'src/core/lib/debug/trace.cc',
        'src/core/lib/event_engine/channel_args_endpoint_config.cc',
        'src/core/lib/event_engine/default_event_engine.cc',
        'src/core/lib/event_engine/default_event_engine_factory.cc',
        'src/core/lib/event_engine/executor/threaded_executor.cc',
        'src/core/lib/event_engine/forkable.cc',
        'src/core/lib/event_engine/memory_allocator.cc',
        'src/core/lib/event_engine/posix_engine/posix_engine.cc',
        'src/core/lib/event_engine/posix_engine/timer.cc',
        'src/core/lib/event_engine/posix_engine/timer_heap.cc',
        'src/core/lib/event_engine/posix_engine/timer_manager.cc',
        'src/core/lib/event_engine/resolved_address.cc',
        'src/core/lib/event_engine/slice.cc',
        'src/core/lib/event_engine/slice_buffer.cc',
        'src/core/lib/event_engine/thread_pool.cc',
        'src/core/lib/event_engine/time_util.cc',
        'src/core/lib/event_engine/trace.cc',
        'src/core/lib/event_engine/utils.cc',
        'src/core/lib/event_engine/windows/iocp.cc',
        'src/core/lib/event_engine/windows/win_socket.cc',
        'src/core/lib/event_engine/windows/windows_engine.cc',
        'src/core/lib/experiments/config.cc',
        'src/core/lib/experiments/experiments.cc',
        'src/core/lib/gpr/murmur_hash.cc',
        'src/core/lib/gprpp/status_helper.cc',
        'src/core/lib/gprpp/time.cc',
        'src/core/lib/gprpp/time_averaged_stats.cc',
        'src/core/lib/gprpp/validation_errors.cc',
        'src/core/lib/gprpp/work_serializer.cc',
        'src/core/lib/handshaker/proxy_mapper_registry.cc',
        'src/core/lib/http/format_request.cc',
        'src/core/lib/http/httpcli.cc',
        'src/core/lib/http/httpcli_security_connector.cc',
        'src/core/lib/http/parser.cc',
        'src/core/lib/iomgr/buffer_list.cc',
        'src/core/lib/iomgr/call_combiner.cc',
        'src/core/lib/iomgr/cfstream_handle.cc',
        'src/core/lib/iomgr/combiner.cc',
        'src/core/lib/iomgr/dualstack_socket_posix.cc',
        'src/core/lib/iomgr/endpoint.cc',
        'src/core/lib/iomgr/endpoint_cfstream.cc',
        'src/core/lib/iomgr/endpoint_pair_posix.cc',
        'src/core/lib/iomgr/endpoint_pair_windows.cc',
        'src/core/lib/iomgr/error.cc',
        'src/core/lib/iomgr/error_cfstream.cc',
        'src/core/lib/iomgr/ev_apple.cc',
        'src/core/lib/iomgr/ev_epoll1_linux.cc',
        'src/core/lib/iomgr/ev_poll_posix.cc',
        'src/core/lib/iomgr/ev_posix.cc',
        'src/core/lib/iomgr/ev_windows.cc',
        'src/core/lib/iomgr/exec_ctx.cc',
        'src/core/lib/iomgr/executor.cc',
        'src/core/lib/iomgr/fork_posix.cc',
        'src/core/lib/iomgr/fork_windows.cc',
        'src/core/lib/iomgr/gethostname_fallback.cc',
        'src/core/lib/iomgr/gethostname_host_name_max.cc',
        'src/core/lib/iomgr/gethostname_sysconf.cc',
        'src/core/lib/iomgr/grpc_if_nametoindex_posix.cc',
        'src/core/lib/iomgr/grpc_if_nametoindex_unsupported.cc',
        'src/core/lib/iomgr/internal_errqueue.cc',
        'src/core/lib/iomgr/iocp_windows.cc',
        'src/core/lib/iomgr/iomgr.cc',
        'src/core/lib/iomgr/iomgr_internal.cc',
        'src/core/lib/iomgr/iomgr_posix.cc',
        'src/core/lib/iomgr/iomgr_posix_cfstream.cc',
        'src/core/lib/iomgr/iomgr_windows.cc',
        'src/core/lib/iomgr/load_file.cc',
        'src/core/lib/iomgr/lockfree_event.cc',
        'src/core/lib/iomgr/polling_entity.cc',
        'src/core/lib/iomgr/pollset.cc',
        'src/core/lib/iomgr/pollset_set.cc',
        'src/core/lib/iomgr/pollset_set_windows.cc',
        'src/core/lib/iomgr/pollset_windows.cc',
        'src/core/lib/iomgr/resolve_address.cc',
        'src/core/lib/iomgr/resolve_address_posix.cc',
        'src/core/lib/iomgr/resolve_address_windows.cc',
        'src/core/lib/iomgr/sockaddr_utils_posix.cc',
        'src/core/lib/iomgr/socket_factory_posix.cc',
        'src/core/lib/iomgr/socket_mutator.cc',
        'src/core/lib/iomgr/socket_utils_common_posix.cc',
        'src/core/lib/iomgr/socket_utils_linux.cc',
        'src/core/lib/iomgr/socket_utils_posix.cc',
        'src/core/lib/iomgr/socket_utils_windows.cc',
        'src/core/lib/iomgr/socket_windows.cc',
        'src/core/lib/iomgr/tcp_client.cc',
        'src/core/lib/iomgr/tcp_client_cfstream.cc',
        'src/core/lib/iomgr/tcp_client_posix.cc',
        'src/core/lib/iomgr/tcp_client_windows.cc',
        'src/core/lib/iomgr/tcp_posix.cc',
        'src/core/lib/iomgr/tcp_server.cc',
        'src/core/lib/iomgr/tcp_server_posix.cc',
        'src/core/lib/iomgr/tcp_server_utils_posix_common.cc',
        'src/core/lib/iomgr/tcp_server_utils_posix_ifaddrs.cc',
        'src/core/lib/iomgr/tcp_server_utils_posix_noifaddrs.cc',
        'src/core/lib/iomgr/tcp_server_windows.cc',
        'src/core/lib/iomgr/tcp_windows.cc',
        'src/core/lib/iomgr/timer.cc',
        'src/core/lib/iomgr/timer_generic.cc',
        'src/core/lib/iomgr/timer_heap.cc',
        'src/core/lib/iomgr/timer_manager.cc',
        'src/core/lib/iomgr/unix_sockets_posix.cc',
        'src/core/lib/iomgr/unix_sockets_posix_noop.cc',
        'src/core/lib/iomgr/wakeup_fd_eventfd.cc',
        'src/core/lib/iomgr/wakeup_fd_nospecial.cc',
        'src/core/lib/iomgr/wakeup_fd_pipe.cc',
        'src/core/lib/iomgr/wakeup_fd_posix.cc',
        'src/core/lib/json/json_object_loader.cc',
        'src/core/lib/json/json_reader.cc',
        'src/core/lib/json/json_util.cc',
        'src/core/lib/json/json_writer.cc',
        'src/core/lib/load_balancing/lb_policy.cc',
        'src/core/lib/load_balancing/lb_policy_registry.cc',
        'src/core/lib/matchers/matchers.cc',
        'src/core/lib/promise/activity.cc',
        'src/core/lib/promise/sleep.cc',
        'src/core/lib/resolver/resolver.cc',
        'src/core/lib/resolver/resolver_registry.cc',
        'src/core/lib/resolver/server_address.cc',
        'src/core/lib/resource_quota/api.cc',
        'src/core/lib/resource_quota/arena.cc',
        'src/core/lib/resource_quota/memory_quota.cc',
        'src/core/lib/resource_quota/periodic_update.cc',
        'src/core/lib/resource_quota/resource_quota.cc',
        'src/core/lib/resource_quota/thread_quota.cc',
        'src/core/lib/resource_quota/trace.cc',
        'src/core/lib/security/authorization/authorization_policy_provider_vtable.cc',
        'src/core/lib/security/authorization/evaluate_args.cc',
        'src/core/lib/security/authorization/grpc_authorization_engine.cc',
        'src/core/lib/security/authorization/grpc_server_authz_filter.cc',
        'src/core/lib/security/authorization/matchers.cc',
        'src/core/lib/security/authorization/rbac_policy.cc',
        'src/core/lib/security/certificate_provider/certificate_provider_registry.cc',
        'src/core/lib/security/context/security_context.cc',
        'src/core/lib/security/credentials/alts/alts_credentials.cc',
        'src/core/lib/security/credentials/alts/check_gcp_environment.cc',
        'src/core/lib/security/credentials/alts/check_gcp_environment_linux.cc',
        'src/core/lib/security/credentials/alts/check_gcp_environment_no_op.cc',
        'src/core/lib/security/credentials/alts/check_gcp_environment_windows.cc',
        'src/core/lib/security/credentials/alts/grpc_alts_credentials_client_options.cc',
        'src/core/lib/security/credentials/alts/grpc_alts_credentials_options.cc',
        'src/core/lib/security/credentials/alts/grpc_alts_credentials_server_options.cc',
        'src/core/lib/security/credentials/call_creds_util.cc',
        'src/core/lib/security/credentials/channel_creds_registry_init.cc',
        'src/core/lib/security/credentials/composite/composite_credentials.cc',
        'src/core/lib/security/credentials/credentials.cc',
        'src/core/lib/security/credentials/external/aws_external_account_credentials.cc',
        'src/core/lib/security/credentials/external/aws_request_signer.cc',
        'src/core/lib/security/credentials/external/external_account_credentials.cc',
        'src/core/lib/security/credentials/external/file_external_account_credentials.cc',
        'src/core/lib/security/credentials/external/url_external_account_credentials.cc',
        'src/core/lib/security/credentials/fake/fake_credentials.cc',
        'src/core/lib/security/credentials/google_default/credentials_generic.cc',
        'src/core/lib/security/credentials/google_default/google_default_credentials.cc',
        'src/core/lib/security/credentials/iam/iam_credentials.cc',
        'src/core/lib/security/credentials/insecure/insecure_credentials.cc',
        'src/core/lib/security/credentials/jwt/json_token.cc',
        'src/core/lib/security/credentials/jwt/jwt_credentials.cc',
        'src/core/lib/security/credentials/jwt/jwt_verifier.cc',
        'src/core/lib/security/credentials/local/local_credentials.cc',
        'src/core/lib/security/credentials/oauth2/oauth2_credentials.cc',
        'src/core/lib/security/credentials/plugin/plugin_credentials.cc',
        'src/core/lib/security/credentials/ssl/ssl_credentials.cc',
        'src/core/lib/security/credentials/tls/grpc_tls_certificate_distributor.cc',
        'src/core/lib/security/credentials/tls/grpc_tls_certificate_provider.cc',
        'src/core/lib/security/credentials/tls/grpc_tls_certificate_verifier.cc',
        'src/core/lib/security/credentials/tls/grpc_tls_credentials_options.cc',
        'src/core/lib/security/credentials/tls/tls_credentials.cc',
        'src/core/lib/security/credentials/tls/tls_utils.cc',
        'src/core/lib/security/credentials/xds/xds_credentials.cc',
        'src/core/lib/security/security_connector/alts/alts_security_connector.cc',
        'src/core/lib/security/security_connector/fake/fake_security_connector.cc',
        'src/core/lib/security/security_connector/insecure/insecure_security_connector.cc',
        'src/core/lib/security/security_connector/load_system_roots_fallback.cc',
        'src/core/lib/security/security_connector/load_system_roots_supported.cc',
        'src/core/lib/security/security_connector/local/local_security_connector.cc',
        'src/core/lib/security/security_connector/security_connector.cc',
        'src/core/lib/security/security_connector/ssl/ssl_security_connector.cc',
        'src/core/lib/security/security_connector/ssl_utils.cc',
        'src/core/lib/security/security_connector/ssl_utils_config.cc',
        'src/core/lib/security/security_connector/tls/tls_security_connector.cc',
        'src/core/lib/security/transport/client_auth_filter.cc',
        'src/core/lib/security/transport/secure_endpoint.cc',
        'src/core/lib/security/transport/security_handshaker.cc',
        'src/core/lib/security/transport/server_auth_filter.cc',
        'src/core/lib/security/transport/tsi_error.cc',
        'src/core/lib/security/util/json_util.cc',
        'src/core/lib/service_config/service_config_impl.cc',
        'src/core/lib/service_config/service_config_parser.cc',
        'src/core/lib/slice/b64.cc',
        'src/core/lib/slice/percent_encoding.cc',
        'src/core/lib/slice/slice.cc',
        'src/core/lib/slice/slice_api.cc',
        'src/core/lib/slice/slice_buffer.cc',
        'src/core/lib/slice/slice_buffer_api.cc',
        'src/core/lib/slice/slice_refcount.cc',
        'src/core/lib/slice/slice_string_helpers.cc',
        'src/core/lib/surface/api_trace.cc',
        'src/core/lib/surface/builtins.cc',
        'src/core/lib/surface/byte_buffer.cc',
        'src/core/lib/surface/byte_buffer_reader.cc',
        'src/core/lib/surface/call.cc',
        'src/core/lib/surface/call_details.cc',
        'src/core/lib/surface/call_log_batch.cc',
        'src/core/lib/surface/channel.cc',
        'src/core/lib/surface/channel_init.cc',
        'src/core/lib/surface/channel_ping.cc',
        'src/core/lib/surface/channel_stack_type.cc',
        'src/core/lib/surface/completion_queue.cc',
        'src/core/lib/surface/completion_queue_factory.cc',
        'src/core/lib/surface/event_string.cc',
        'src/core/lib/surface/init.cc',
        'src/core/lib/surface/init_internally.cc',
        'src/core/lib/surface/lame_client.cc',
        'src/core/lib/surface/metadata_array.cc',
        'src/core/lib/surface/server.cc',
        'src/core/lib/surface/validate_metadata.cc',
        'src/core/lib/surface/version.cc',
        'src/core/lib/transport/bdp_estimator.cc',
        'src/core/lib/transport/connectivity_state.cc',
        'src/core/lib/transport/error_utils.cc',
        'src/core/lib/transport/handshaker.cc',
        'src/core/lib/transport/handshaker_registry.cc',
        'src/core/lib/transport/http_connect_handshaker.cc',
        'src/core/lib/transport/metadata_batch.cc',
        'src/core/lib/transport/parsed_metadata.cc',
        'src/core/lib/transport/pid_controller.cc',
        'src/core/lib/transport/status_conversion.cc',
        'src/core/lib/transport/tcp_connect_handshaker.cc',
        'src/core/lib/transport/timeout_encoding.cc',
        'src/core/lib/transport/transport.cc',
        'src/core/lib/transport/transport_op_string.cc',
        'src/core/lib/uri/uri_parser.cc',
        'src/core/plugin_registry/grpc_plugin_registry.cc',
        'src/core/plugin_registry/grpc_plugin_registry_extra.cc',
        'src/core/tsi/alts/crypt/aes_gcm.cc',
        'src/core/tsi/alts/crypt/gsec.cc',
        'src/core/tsi/alts/frame_protector/alts_counter.cc',
        'src/core/tsi/alts/frame_protector/alts_crypter.cc',
        'src/core/tsi/alts/frame_protector/alts_frame_protector.cc',
        'src/core/tsi/alts/frame_protector/alts_record_protocol_crypter_common.cc',
        'src/core/tsi/alts/frame_protector/alts_seal_privacy_integrity_crypter.cc',
        'src/core/tsi/alts/frame_protector/alts_unseal_privacy_integrity_crypter.cc',
        'src/core/tsi/alts/frame_protector/frame_handler.cc',
        'src/core/tsi/alts/handshaker/alts_handshaker_client.cc',
        'src/core/tsi/alts/handshaker/alts_shared_resource.cc',
        'src/core/tsi/alts/handshaker/alts_tsi_handshaker.cc',
        'src/core/tsi/alts/handshaker/alts_tsi_utils.cc',
        'src/core/tsi/alts/handshaker/transport_security_common_api.cc',
        'src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_integrity_only_record_protocol.cc',
        'src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_privacy_integrity_record_protocol.cc',
        'src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_record_protocol_common.cc',
        'src/core/tsi/alts/zero_copy_frame_protector/alts_iovec_record_protocol.cc',
        'src/core/tsi/alts/zero_copy_frame_protector/alts_zero_copy_grpc_protector.cc',
        'src/core/tsi/fake_transport_security.cc',
        'src/core/tsi/local_transport_security.cc',
        'src/core/tsi/ssl/key_logging/ssl_key_logging.cc',
        'src/core/tsi/ssl/session_cache/ssl_session_boringssl.cc',
        'src/core/tsi/ssl/session_cache/ssl_session_cache.cc',
        'src/core/tsi/ssl/session_cache/ssl_session_openssl.cc',
        'src/core/tsi/ssl_transport_security.cc',
        'src/core/tsi/transport_security.cc',
        'src/core/tsi/transport_security_grpc.cc',
      ],
    },
    {
      'target_name': 'grpc_test_util',
      'type': 'static_library',
      'dependencies': [
        'absl/debugging:failure_signal_handler',
        'absl/debugging:stacktrace',
        'absl/debugging:symbolize',
        'grpc',
      ],
      'sources': [
        'test/core/event_engine/test_init.cc',
        'test/core/util/build.cc',
        'test/core/util/port.cc',
        'test/core/util/port_isolated_runtime_environment.cc',
        'test/core/util/port_server_client.cc',
        'test/core/util/reconnect_server.cc',
        'test/core/util/stack_tracer.cc',
        'test/core/util/test_config.cc',
        'test/core/util/test_tcp_server.cc',
        'test/core/util/tls_utils.cc',
      ],
    },
    {
      'target_name': 'grpc_test_util_unsecure',
      'type': 'static_library',
      'dependencies': [
        'absl/debugging:failure_signal_handler',
        'absl/debugging:stacktrace',
        'absl/debugging:symbolize',
        'grpc_unsecure',
      ],
      'sources': [
        'test/core/event_engine/test_init.cc',
        'test/core/util/build.cc',
        'test/core/util/port.cc',
        'test/core/util/port_isolated_runtime_environment.cc',
        'test/core/util/port_server_client.cc',
        'test/core/util/reconnect_server.cc',
        'test/core/util/stack_tracer.cc',
        'test/core/util/test_config.cc',
        'test/core/util/test_tcp_server.cc',
      ],
    },
    {
      'target_name': 'grpc_unsecure',
      'type': 'static_library',
      'dependencies': [
        'absl/container:flat_hash_map',
        'absl/container:flat_hash_set',
        'absl/container:inlined_vector',
        'absl/functional:any_invocable',
        'absl/functional:bind_front',
        'absl/functional:function_ref',
        'absl/hash:hash',
        'absl/meta:type_traits',
        'absl/status:statusor',
        'absl/types:span',
        'absl/utility:utility',
        'gpr',
        'address_sorting',
        'upb',
      ],
      'sources': [
        'src/core/ext/filters/census/grpc_context.cc',
        'src/core/ext/filters/channel_idle/channel_idle_filter.cc',
        'src/core/ext/filters/channel_idle/idle_filter_state.cc',
        'src/core/ext/filters/client_channel/backend_metric.cc',
        'src/core/ext/filters/client_channel/backup_poller.cc',
        'src/core/ext/filters/client_channel/channel_connectivity.cc',
        'src/core/ext/filters/client_channel/client_channel.cc',
        'src/core/ext/filters/client_channel/client_channel_channelz.cc',
        'src/core/ext/filters/client_channel/client_channel_factory.cc',
        'src/core/ext/filters/client_channel/client_channel_plugin.cc',
        'src/core/ext/filters/client_channel/config_selector.cc',
        'src/core/ext/filters/client_channel/dynamic_filters.cc',
        'src/core/ext/filters/client_channel/global_subchannel_pool.cc',
        'src/core/ext/filters/client_channel/health/health_check_client.cc',
        'src/core/ext/filters/client_channel/http_proxy.cc',
        'src/core/ext/filters/client_channel/lb_policy/address_filtering.cc',
        'src/core/ext/filters/client_channel/lb_policy/child_policy_handler.cc',
        'src/core/ext/filters/client_channel/lb_policy/grpclb/client_load_reporting_filter.cc',
        'src/core/ext/filters/client_channel/lb_policy/grpclb/grpclb.cc',
        'src/core/ext/filters/client_channel/lb_policy/grpclb/grpclb_balancer_addresses.cc',
        'src/core/ext/filters/client_channel/lb_policy/grpclb/grpclb_client_stats.cc',
        'src/core/ext/filters/client_channel/lb_policy/grpclb/load_balancer_api.cc',
        'src/core/ext/filters/client_channel/lb_policy/oob_backend_metric.cc',
        'src/core/ext/filters/client_channel/lb_policy/outlier_detection/outlier_detection.cc',
        'src/core/ext/filters/client_channel/lb_policy/pick_first/pick_first.cc',
        'src/core/ext/filters/client_channel/lb_policy/priority/priority.cc',
        'src/core/ext/filters/client_channel/lb_policy/ring_hash/ring_hash.cc',
        'src/core/ext/filters/client_channel/lb_policy/rls/rls.cc',
        'src/core/ext/filters/client_channel/lb_policy/round_robin/round_robin.cc',
        'src/core/ext/filters/client_channel/lb_policy/weighted_target/weighted_target.cc',
        'src/core/ext/filters/client_channel/local_subchannel_pool.cc',
        'src/core/ext/filters/client_channel/resolver/binder/binder_resolver.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/dns_resolver_ares.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_ev_driver_posix.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_ev_driver_windows.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_wrapper.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_wrapper_posix.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_wrapper_windows.cc',
        'src/core/ext/filters/client_channel/resolver/dns/dns_resolver_selection.cc',
        'src/core/ext/filters/client_channel/resolver/dns/native/dns_resolver.cc',
        'src/core/ext/filters/client_channel/resolver/fake/fake_resolver.cc',
        'src/core/ext/filters/client_channel/resolver/polling_resolver.cc',
        'src/core/ext/filters/client_channel/resolver/sockaddr/sockaddr_resolver.cc',
        'src/core/ext/filters/client_channel/resolver_result_parsing.cc',
        'src/core/ext/filters/client_channel/retry_filter.cc',
        'src/core/ext/filters/client_channel/retry_service_config.cc',
        'src/core/ext/filters/client_channel/retry_throttle.cc',
        'src/core/ext/filters/client_channel/service_config_channel_arg_filter.cc',
        'src/core/ext/filters/client_channel/subchannel.cc',
        'src/core/ext/filters/client_channel/subchannel_pool_interface.cc',
        'src/core/ext/filters/client_channel/subchannel_stream_client.cc',
        'src/core/ext/filters/deadline/deadline_filter.cc',
        'src/core/ext/filters/fault_injection/fault_injection_filter.cc',
        'src/core/ext/filters/fault_injection/service_config_parser.cc',
        'src/core/ext/filters/http/client/http_client_filter.cc',
        'src/core/ext/filters/http/client_authority_filter.cc',
        'src/core/ext/filters/http/http_filters_plugin.cc',
        'src/core/ext/filters/http/message_compress/message_compress_filter.cc',
        'src/core/ext/filters/http/message_compress/message_decompress_filter.cc',
        'src/core/ext/filters/http/server/http_server_filter.cc',
        'src/core/ext/filters/message_size/message_size_filter.cc',
        'src/core/ext/transport/chttp2/client/chttp2_connector.cc',
        'src/core/ext/transport/chttp2/server/chttp2_server.cc',
        'src/core/ext/transport/chttp2/transport/bin_decoder.cc',
        'src/core/ext/transport/chttp2/transport/bin_encoder.cc',
        'src/core/ext/transport/chttp2/transport/chttp2_transport.cc',
        'src/core/ext/transport/chttp2/transport/context_list.cc',
        'src/core/ext/transport/chttp2/transport/decode_huff.cc',
        'src/core/ext/transport/chttp2/transport/flow_control.cc',
        'src/core/ext/transport/chttp2/transport/frame_data.cc',
        'src/core/ext/transport/chttp2/transport/frame_goaway.cc',
        'src/core/ext/transport/chttp2/transport/frame_ping.cc',
        'src/core/ext/transport/chttp2/transport/frame_rst_stream.cc',
        'src/core/ext/transport/chttp2/transport/frame_settings.cc',
        'src/core/ext/transport/chttp2/transport/frame_window_update.cc',
        'src/core/ext/transport/chttp2/transport/hpack_encoder.cc',
        'src/core/ext/transport/chttp2/transport/hpack_encoder_table.cc',
        'src/core/ext/transport/chttp2/transport/hpack_parser.cc',
        'src/core/ext/transport/chttp2/transport/hpack_parser_table.cc',
        'src/core/ext/transport/chttp2/transport/http2_settings.cc',
        'src/core/ext/transport/chttp2/transport/huffsyms.cc',
        'src/core/ext/transport/chttp2/transport/parsing.cc',
        'src/core/ext/transport/chttp2/transport/stream_lists.cc',
        'src/core/ext/transport/chttp2/transport/stream_map.cc',
        'src/core/ext/transport/chttp2/transport/varint.cc',
        'src/core/ext/transport/chttp2/transport/writing.cc',
        'src/core/ext/transport/inproc/inproc_plugin.cc',
        'src/core/ext/transport/inproc/inproc_transport.cc',
        'src/core/ext/upb-generated/google/api/annotations.upb.c',
        'src/core/ext/upb-generated/google/api/http.upb.c',
        'src/core/ext/upb-generated/google/protobuf/any.upb.c',
        'src/core/ext/upb-generated/google/protobuf/descriptor.upb.c',
        'src/core/ext/upb-generated/google/protobuf/duration.upb.c',
        'src/core/ext/upb-generated/google/protobuf/empty.upb.c',
        'src/core/ext/upb-generated/google/protobuf/struct.upb.c',
        'src/core/ext/upb-generated/google/protobuf/timestamp.upb.c',
        'src/core/ext/upb-generated/google/protobuf/wrappers.upb.c',
        'src/core/ext/upb-generated/google/rpc/status.upb.c',
        'src/core/ext/upb-generated/src/proto/grpc/health/v1/health.upb.c',
        'src/core/ext/upb-generated/src/proto/grpc/lb/v1/load_balancer.upb.c',
        'src/core/ext/upb-generated/src/proto/grpc/lookup/v1/rls.upb.c',
        'src/core/ext/upb-generated/validate/validate.upb.c',
        'src/core/ext/upb-generated/xds/data/orca/v3/orca_load_report.upb.c',
        'src/core/ext/upb-generated/xds/service/orca/v3/orca.upb.c',
        'src/core/lib/address_utils/parse_address.cc',
        'src/core/lib/address_utils/sockaddr_utils.cc',
        'src/core/lib/backoff/backoff.cc',
        'src/core/lib/channel/channel_args.cc',
        'src/core/lib/channel/channel_args_preconditioning.cc',
        'src/core/lib/channel/channel_stack.cc',
        'src/core/lib/channel/channel_stack_builder.cc',
        'src/core/lib/channel/channel_stack_builder_impl.cc',
        'src/core/lib/channel/channel_trace.cc',
        'src/core/lib/channel/channelz.cc',
        'src/core/lib/channel/channelz_registry.cc',
        'src/core/lib/channel/connected_channel.cc',
        'src/core/lib/channel/promise_based_filter.cc',
        'src/core/lib/channel/status_util.cc',
        'src/core/lib/compression/compression.cc',
        'src/core/lib/compression/compression_internal.cc',
        'src/core/lib/compression/message_compress.cc',
        'src/core/lib/config/core_configuration.cc',
        'src/core/lib/debug/stats.cc',
        'src/core/lib/debug/stats_data.cc',
        'src/core/lib/debug/trace.cc',
        'src/core/lib/event_engine/channel_args_endpoint_config.cc',
        'src/core/lib/event_engine/default_event_engine.cc',
        'src/core/lib/event_engine/default_event_engine_factory.cc',
        'src/core/lib/event_engine/executor/threaded_executor.cc',
        'src/core/lib/event_engine/forkable.cc',
        'src/core/lib/event_engine/memory_allocator.cc',
        'src/core/lib/event_engine/posix_engine/posix_engine.cc',
        'src/core/lib/event_engine/posix_engine/timer.cc',
        'src/core/lib/event_engine/posix_engine/timer_heap.cc',
        'src/core/lib/event_engine/posix_engine/timer_manager.cc',
        'src/core/lib/event_engine/resolved_address.cc',
        'src/core/lib/event_engine/slice.cc',
        'src/core/lib/event_engine/slice_buffer.cc',
        'src/core/lib/event_engine/thread_pool.cc',
        'src/core/lib/event_engine/time_util.cc',
        'src/core/lib/event_engine/trace.cc',
        'src/core/lib/event_engine/utils.cc',
        'src/core/lib/event_engine/windows/iocp.cc',
        'src/core/lib/event_engine/windows/win_socket.cc',
        'src/core/lib/event_engine/windows/windows_engine.cc',
        'src/core/lib/experiments/config.cc',
        'src/core/lib/experiments/experiments.cc',
        'src/core/lib/gpr/murmur_hash.cc',
        'src/core/lib/gprpp/status_helper.cc',
        'src/core/lib/gprpp/time.cc',
        'src/core/lib/gprpp/time_averaged_stats.cc',
        'src/core/lib/gprpp/validation_errors.cc',
        'src/core/lib/gprpp/work_serializer.cc',
        'src/core/lib/handshaker/proxy_mapper_registry.cc',
        'src/core/lib/http/format_request.cc',
        'src/core/lib/http/httpcli.cc',
        'src/core/lib/http/parser.cc',
        'src/core/lib/iomgr/buffer_list.cc',
        'src/core/lib/iomgr/call_combiner.cc',
        'src/core/lib/iomgr/cfstream_handle.cc',
        'src/core/lib/iomgr/combiner.cc',
        'src/core/lib/iomgr/dualstack_socket_posix.cc',
        'src/core/lib/iomgr/endpoint.cc',
        'src/core/lib/iomgr/endpoint_cfstream.cc',
        'src/core/lib/iomgr/endpoint_pair_posix.cc',
        'src/core/lib/iomgr/endpoint_pair_windows.cc',
        'src/core/lib/iomgr/error.cc',
        'src/core/lib/iomgr/error_cfstream.cc',
        'src/core/lib/iomgr/ev_apple.cc',
        'src/core/lib/iomgr/ev_epoll1_linux.cc',
        'src/core/lib/iomgr/ev_poll_posix.cc',
        'src/core/lib/iomgr/ev_posix.cc',
        'src/core/lib/iomgr/ev_windows.cc',
        'src/core/lib/iomgr/exec_ctx.cc',
        'src/core/lib/iomgr/executor.cc',
        'src/core/lib/iomgr/fork_posix.cc',
        'src/core/lib/iomgr/fork_windows.cc',
        'src/core/lib/iomgr/gethostname_fallback.cc',
        'src/core/lib/iomgr/gethostname_host_name_max.cc',
        'src/core/lib/iomgr/gethostname_sysconf.cc',
        'src/core/lib/iomgr/grpc_if_nametoindex_posix.cc',
        'src/core/lib/iomgr/grpc_if_nametoindex_unsupported.cc',
        'src/core/lib/iomgr/internal_errqueue.cc',
        'src/core/lib/iomgr/iocp_windows.cc',
        'src/core/lib/iomgr/iomgr.cc',
        'src/core/lib/iomgr/iomgr_internal.cc',
        'src/core/lib/iomgr/iomgr_posix.cc',
        'src/core/lib/iomgr/iomgr_posix_cfstream.cc',
        'src/core/lib/iomgr/iomgr_windows.cc',
        'src/core/lib/iomgr/load_file.cc',
        'src/core/lib/iomgr/lockfree_event.cc',
        'src/core/lib/iomgr/polling_entity.cc',
        'src/core/lib/iomgr/pollset.cc',
        'src/core/lib/iomgr/pollset_set.cc',
        'src/core/lib/iomgr/pollset_set_windows.cc',
        'src/core/lib/iomgr/pollset_windows.cc',
        'src/core/lib/iomgr/resolve_address.cc',
        'src/core/lib/iomgr/resolve_address_posix.cc',
        'src/core/lib/iomgr/resolve_address_windows.cc',
        'src/core/lib/iomgr/sockaddr_utils_posix.cc',
        'src/core/lib/iomgr/socket_factory_posix.cc',
        'src/core/lib/iomgr/socket_mutator.cc',
        'src/core/lib/iomgr/socket_utils_common_posix.cc',
        'src/core/lib/iomgr/socket_utils_linux.cc',
        'src/core/lib/iomgr/socket_utils_posix.cc',
        'src/core/lib/iomgr/socket_utils_windows.cc',
        'src/core/lib/iomgr/socket_windows.cc',
        'src/core/lib/iomgr/tcp_client.cc',
        'src/core/lib/iomgr/tcp_client_cfstream.cc',
        'src/core/lib/iomgr/tcp_client_posix.cc',
        'src/core/lib/iomgr/tcp_client_windows.cc',
        'src/core/lib/iomgr/tcp_posix.cc',
        'src/core/lib/iomgr/tcp_server.cc',
        'src/core/lib/iomgr/tcp_server_posix.cc',
        'src/core/lib/iomgr/tcp_server_utils_posix_common.cc',
        'src/core/lib/iomgr/tcp_server_utils_posix_ifaddrs.cc',
        'src/core/lib/iomgr/tcp_server_utils_posix_noifaddrs.cc',
        'src/core/lib/iomgr/tcp_server_windows.cc',
        'src/core/lib/iomgr/tcp_windows.cc',
        'src/core/lib/iomgr/timer.cc',
        'src/core/lib/iomgr/timer_generic.cc',
        'src/core/lib/iomgr/timer_heap.cc',
        'src/core/lib/iomgr/timer_manager.cc',
        'src/core/lib/iomgr/unix_sockets_posix.cc',
        'src/core/lib/iomgr/unix_sockets_posix_noop.cc',
        'src/core/lib/iomgr/wakeup_fd_eventfd.cc',
        'src/core/lib/iomgr/wakeup_fd_nospecial.cc',
        'src/core/lib/iomgr/wakeup_fd_pipe.cc',
        'src/core/lib/iomgr/wakeup_fd_posix.cc',
        'src/core/lib/json/json_object_loader.cc',
        'src/core/lib/json/json_reader.cc',
        'src/core/lib/json/json_util.cc',
        'src/core/lib/json/json_writer.cc',
        'src/core/lib/load_balancing/lb_policy.cc',
        'src/core/lib/load_balancing/lb_policy_registry.cc',
        'src/core/lib/promise/activity.cc',
        'src/core/lib/promise/sleep.cc',
        'src/core/lib/resolver/resolver.cc',
        'src/core/lib/resolver/resolver_registry.cc',
        'src/core/lib/resolver/server_address.cc',
        'src/core/lib/resource_quota/api.cc',
        'src/core/lib/resource_quota/arena.cc',
        'src/core/lib/resource_quota/memory_quota.cc',
        'src/core/lib/resource_quota/periodic_update.cc',
        'src/core/lib/resource_quota/resource_quota.cc',
        'src/core/lib/resource_quota/thread_quota.cc',
        'src/core/lib/resource_quota/trace.cc',
        'src/core/lib/security/authorization/authorization_policy_provider_vtable.cc',
        'src/core/lib/security/authorization/evaluate_args.cc',
        'src/core/lib/security/authorization/grpc_server_authz_filter.cc',
        'src/core/lib/security/certificate_provider/certificate_provider_registry.cc',
        'src/core/lib/security/context/security_context.cc',
        'src/core/lib/security/credentials/call_creds_util.cc',
        'src/core/lib/security/credentials/composite/composite_credentials.cc',
        'src/core/lib/security/credentials/credentials.cc',
        'src/core/lib/security/credentials/fake/fake_credentials.cc',
        'src/core/lib/security/credentials/insecure/insecure_credentials.cc',
        'src/core/lib/security/credentials/plugin/plugin_credentials.cc',
        'src/core/lib/security/credentials/tls/tls_utils.cc',
        'src/core/lib/security/security_connector/fake/fake_security_connector.cc',
        'src/core/lib/security/security_connector/insecure/insecure_security_connector.cc',
        'src/core/lib/security/security_connector/load_system_roots_fallback.cc',
        'src/core/lib/security/security_connector/load_system_roots_supported.cc',
        'src/core/lib/security/security_connector/security_connector.cc',
        'src/core/lib/security/transport/client_auth_filter.cc',
        'src/core/lib/security/transport/secure_endpoint.cc',
        'src/core/lib/security/transport/security_handshaker.cc',
        'src/core/lib/security/transport/server_auth_filter.cc',
        'src/core/lib/security/transport/tsi_error.cc',
        'src/core/lib/security/util/json_util.cc',
        'src/core/lib/service_config/service_config_impl.cc',
        'src/core/lib/service_config/service_config_parser.cc',
        'src/core/lib/slice/b64.cc',
        'src/core/lib/slice/percent_encoding.cc',
        'src/core/lib/slice/slice.cc',
        'src/core/lib/slice/slice_api.cc',
        'src/core/lib/slice/slice_buffer.cc',
        'src/core/lib/slice/slice_buffer_api.cc',
        'src/core/lib/slice/slice_refcount.cc',
        'src/core/lib/slice/slice_string_helpers.cc',
        'src/core/lib/surface/api_trace.cc',
        'src/core/lib/surface/builtins.cc',
        'src/core/lib/surface/byte_buffer.cc',
        'src/core/lib/surface/byte_buffer_reader.cc',
        'src/core/lib/surface/call.cc',
        'src/core/lib/surface/call_details.cc',
        'src/core/lib/surface/call_log_batch.cc',
        'src/core/lib/surface/channel.cc',
        'src/core/lib/surface/channel_init.cc',
        'src/core/lib/surface/channel_ping.cc',
        'src/core/lib/surface/channel_stack_type.cc',
        'src/core/lib/surface/completion_queue.cc',
        'src/core/lib/surface/completion_queue_factory.cc',
        'src/core/lib/surface/event_string.cc',
        'src/core/lib/surface/init.cc',
        'src/core/lib/surface/init_internally.cc',
        'src/core/lib/surface/lame_client.cc',
        'src/core/lib/surface/metadata_array.cc',
        'src/core/lib/surface/server.cc',
        'src/core/lib/surface/validate_metadata.cc',
        'src/core/lib/surface/version.cc',
        'src/core/lib/transport/bdp_estimator.cc',
        'src/core/lib/transport/connectivity_state.cc',
        'src/core/lib/transport/error_utils.cc',
        'src/core/lib/transport/handshaker.cc',
        'src/core/lib/transport/handshaker_registry.cc',
        'src/core/lib/transport/http_connect_handshaker.cc',
        'src/core/lib/transport/metadata_batch.cc',
        'src/core/lib/transport/parsed_metadata.cc',
        'src/core/lib/transport/pid_controller.cc',
        'src/core/lib/transport/status_conversion.cc',
        'src/core/lib/transport/tcp_connect_handshaker.cc',
        'src/core/lib/transport/timeout_encoding.cc',
        'src/core/lib/transport/transport.cc',
        'src/core/lib/transport/transport_op_string.cc',
        'src/core/lib/uri/uri_parser.cc',
        'src/core/plugin_registry/grpc_plugin_registry.cc',
        'src/core/plugin_registry/grpc_plugin_registry_noextra.cc',
        'src/core/tsi/fake_transport_security.cc',
        'src/core/tsi/local_transport_security.cc',
        'src/core/tsi/transport_security.cc',
        'src/core/tsi/transport_security_grpc.cc',
      ],
    },
    {
      'target_name': 'benchmark_helpers',
      'type': 'static_library',
      'dependencies': [
        'benchmark',
        'grpc++_unsecure',
        'grpc_test_util_unsecure',
        'grpc++_test_config',
      ],
      'sources': [
        'src/proto/grpc/testing/echo.proto',
        'src/proto/grpc/testing/echo_messages.proto',
        'src/proto/grpc/testing/simple_messages.proto',
        'src/proto/grpc/testing/xds/v3/orca_load_report.proto',
        'test/core/util/cmdline.cc',
        'test/core/util/fuzzer_util.cc',
        'test/core/util/grpc_profiler.cc',
        'test/core/util/histogram.cc',
        'test/core/util/mock_endpoint.cc',
        'test/core/util/parse_hexstring.cc',
        'test/core/util/passthru_endpoint.cc',
        'test/core/util/resolve_localhost_ip46.cc',
        'test/core/util/slice_splitter.cc',
        'test/core/util/subprocess_posix.cc',
        'test/core/util/subprocess_windows.cc',
        'test/core/util/tracer_util.cc',
        'test/cpp/microbenchmarks/helpers.cc',
      ],
    },
    {
      'target_name': 'grpc++',
      'type': 'static_library',
      'dependencies': [
        'absl/cleanup:cleanup',
        'grpc',
      ],
      'sources': [
        'src/core/ext/transport/binder/client/binder_connector.cc',
        'src/core/ext/transport/binder/client/channel_create.cc',
        'src/core/ext/transport/binder/client/channel_create_impl.cc',
        'src/core/ext/transport/binder/client/connection_id_generator.cc',
        'src/core/ext/transport/binder/client/endpoint_binder_pool.cc',
        'src/core/ext/transport/binder/client/jni_utils.cc',
        'src/core/ext/transport/binder/client/security_policy_setting.cc',
        'src/core/ext/transport/binder/security_policy/binder_security_policy.cc',
        'src/core/ext/transport/binder/server/binder_server.cc',
        'src/core/ext/transport/binder/server/binder_server_credentials.cc',
        'src/core/ext/transport/binder/transport/binder_transport.cc',
        'src/core/ext/transport/binder/utils/ndk_binder.cc',
        'src/core/ext/transport/binder/utils/transport_stream_receiver_impl.cc',
        'src/core/ext/transport/binder/wire_format/binder_android.cc',
        'src/core/ext/transport/binder/wire_format/binder_constants.cc',
        'src/core/ext/transport/binder/wire_format/transaction.cc',
        'src/core/ext/transport/binder/wire_format/wire_reader_impl.cc',
        'src/core/ext/transport/binder/wire_format/wire_writer.cc',
        'src/cpp/client/channel_cc.cc',
        'src/cpp/client/client_callback.cc',
        'src/cpp/client/client_context.cc',
        'src/cpp/client/client_interceptor.cc',
        'src/cpp/client/create_channel.cc',
        'src/cpp/client/create_channel_internal.cc',
        'src/cpp/client/create_channel_posix.cc',
        'src/cpp/client/credentials_cc.cc',
        'src/cpp/client/insecure_credentials.cc',
        'src/cpp/client/secure_credentials.cc',
        'src/cpp/client/xds_credentials.cc',
        'src/cpp/codegen/codegen_init.cc',
        'src/cpp/common/alarm.cc',
        'src/cpp/common/auth_property_iterator.cc',
        'src/cpp/common/channel_arguments.cc',
        'src/cpp/common/channel_filter.cc',
        'src/cpp/common/completion_queue_cc.cc',
        'src/cpp/common/core_codegen.cc',
        'src/cpp/common/resource_quota_cc.cc',
        'src/cpp/common/rpc_method.cc',
        'src/cpp/common/secure_auth_context.cc',
        'src/cpp/common/secure_channel_arguments.cc',
        'src/cpp/common/secure_create_auth_context.cc',
        'src/cpp/common/tls_certificate_provider.cc',
        'src/cpp/common/tls_certificate_verifier.cc',
        'src/cpp/common/tls_credentials_options.cc',
        'src/cpp/common/validate_service_config.cc',
        'src/cpp/common/version_cc.cc',
        'src/cpp/server/async_generic_service.cc',
        'src/cpp/server/channel_argument_option.cc',
        'src/cpp/server/create_default_thread_pool.cc',
        'src/cpp/server/dynamic_thread_pool.cc',
        'src/cpp/server/external_connection_acceptor_impl.cc',
        'src/cpp/server/health/default_health_check_service.cc',
        'src/cpp/server/health/health_check_service.cc',
        'src/cpp/server/health/health_check_service_server_builder_option.cc',
        'src/cpp/server/insecure_server_credentials.cc',
        'src/cpp/server/orca/call_metric_recorder.cc',
        'src/cpp/server/secure_server_credentials.cc',
        'src/cpp/server/server_builder.cc',
        'src/cpp/server/server_callback.cc',
        'src/cpp/server/server_cc.cc',
        'src/cpp/server/server_context.cc',
        'src/cpp/server/server_credentials.cc',
        'src/cpp/server/server_posix.cc',
        'src/cpp/server/xds_server_credentials.cc',
        'src/cpp/thread_manager/thread_manager.cc',
        'src/cpp/util/byte_buffer_cc.cc',
        'src/cpp/util/status.cc',
        'src/cpp/util/string_ref.cc',
        'src/cpp/util/time_cc.cc',
      ],
    },
    {
      'target_name': 'grpc++_alts',
      'type': 'static_library',
      'dependencies': [
        'grpc++',
      ],
      'sources': [
        'src/cpp/common/alts_context.cc',
        'src/cpp/common/alts_util.cc',
      ],
    },
    {
      'target_name': 'grpc++_error_details',
      'type': 'static_library',
      'dependencies': [
        'grpc++',
      ],
      'sources': [
        'src/cpp/util/error_details.cc',
      ],
    },
    {
      'target_name': 'grpc++_reflection',
      'type': 'static_library',
      'dependencies': [
        'grpc++',
      ],
      'sources': [
        'src/proto/grpc/reflection/v1alpha/reflection.proto',
        'src/cpp/ext/proto_server_reflection.cc',
        'src/cpp/ext/proto_server_reflection_plugin.cc',
      ],
    },
    {
      'target_name': 'grpc++_test',
      'type': 'static_library',
      'dependencies': [
        'grpc++',
      ],
      'sources': [
        'src/cpp/client/channel_test_peer.cc',
      ],
    },
    {
      'target_name': 'grpc++_test_config',
      'type': 'static_library',
      'dependencies': [
        'absl/flags:parse',
        'gpr',
      ],
      'sources': [
        'test/cpp/util/test_config_cc.cc',
      ],
    },
    {
      'target_name': 'grpc++_test_util',
      'type': 'static_library',
      'dependencies': [
        'absl/flags:flag',
        'grpc++',
        'grpc_test_util',
      ],
      'sources': [
        'test/core/end2end/data/client_certs.cc',
        'test/core/end2end/data/server1_cert.cc',
        'test/core/end2end/data/server1_key.cc',
        'test/core/end2end/data/test_root_cert.cc',
        'test/core/util/cmdline.cc',
        'test/core/util/fuzzer_util.cc',
        'test/core/util/grpc_profiler.cc',
        'test/core/util/histogram.cc',
        'test/core/util/mock_endpoint.cc',
        'test/core/util/parse_hexstring.cc',
        'test/core/util/passthru_endpoint.cc',
        'test/core/util/resolve_localhost_ip46.cc',
        'test/core/util/slice_splitter.cc',
        'test/core/util/subprocess_posix.cc',
        'test/core/util/subprocess_windows.cc',
        'test/core/util/tracer_util.cc',
        'test/cpp/util/byte_buffer_proto_helper.cc',
        'test/cpp/util/create_test_channel.cc',
        'test/cpp/util/string_ref_helper.cc',
        'test/cpp/util/subprocess.cc',
        'test/cpp/util/test_credentials_provider.cc',
      ],
    },
    {
      'target_name': 'grpc++_unsecure',
      'type': 'static_library',
      'dependencies': [
        'grpc_unsecure',
      ],
      'sources': [
        'src/cpp/client/channel_cc.cc',
        'src/cpp/client/client_callback.cc',
        'src/cpp/client/client_context.cc',
        'src/cpp/client/client_interceptor.cc',
        'src/cpp/client/create_channel.cc',
        'src/cpp/client/create_channel_internal.cc',
        'src/cpp/client/create_channel_posix.cc',
        'src/cpp/client/credentials_cc.cc',
        'src/cpp/client/insecure_credentials.cc',
        'src/cpp/codegen/codegen_init.cc',
        'src/cpp/common/alarm.cc',
        'src/cpp/common/channel_arguments.cc',
        'src/cpp/common/channel_filter.cc',
        'src/cpp/common/completion_queue_cc.cc',
        'src/cpp/common/core_codegen.cc',
        'src/cpp/common/insecure_create_auth_context.cc',
        'src/cpp/common/resource_quota_cc.cc',
        'src/cpp/common/rpc_method.cc',
        'src/cpp/common/validate_service_config.cc',
        'src/cpp/common/version_cc.cc',
        'src/cpp/server/async_generic_service.cc',
        'src/cpp/server/channel_argument_option.cc',
        'src/cpp/server/create_default_thread_pool.cc',
        'src/cpp/server/dynamic_thread_pool.cc',
        'src/cpp/server/external_connection_acceptor_impl.cc',
        'src/cpp/server/health/default_health_check_service.cc',
        'src/cpp/server/health/health_check_service.cc',
        'src/cpp/server/health/health_check_service_server_builder_option.cc',
        'src/cpp/server/insecure_server_credentials.cc',
        'src/cpp/server/orca/call_metric_recorder.cc',
        'src/cpp/server/server_builder.cc',
        'src/cpp/server/server_callback.cc',
        'src/cpp/server/server_cc.cc',
        'src/cpp/server/server_context.cc',
        'src/cpp/server/server_credentials.cc',
        'src/cpp/server/server_posix.cc',
        'src/cpp/thread_manager/thread_manager.cc',
        'src/cpp/util/byte_buffer_cc.cc',
        'src/cpp/util/status.cc',
        'src/cpp/util/string_ref.cc',
        'src/cpp/util/time_cc.cc',
      ],
    },
    {
      'target_name': 'grpc_plugin_support',
      'type': 'static_library',
      'dependencies': [
      ],
      'sources': [
        'src/compiler/cpp_generator.cc',
        'src/compiler/csharp_generator.cc',
        'src/compiler/node_generator.cc',
        'src/compiler/objective_c_generator.cc',
        'src/compiler/php_generator.cc',
        'src/compiler/python_generator.cc',
        'src/compiler/ruby_generator.cc',
      ],
    },
    {
      'target_name': 'grpcpp_channelz',
      'type': 'static_library',
      'dependencies': [
        'grpc++',
      ],
      'sources': [
        'src/proto/grpc/channelz/channelz.proto',
        'src/cpp/server/channelz/channelz_service.cc',
        'src/cpp/server/channelz/channelz_service_plugin.cc',
      ],
    },
    {
      'target_name': 'boringssl',
      'type': 'static_library',
      'dependencies': [
      ],
      'sources': [
        'third_party/boringssl-with-bazel/err_data.c',
        'third_party/boringssl-with-bazel/src/crypto/asn1/a_bitstr.c',
        'third_party/boringssl-with-bazel/src/crypto/asn1/a_bool.c',
        'third_party/boringssl-with-bazel/src/crypto/asn1/a_d2i_fp.c',
        'third_party/boringssl-with-bazel/src/crypto/asn1/a_dup.c',
        'third_party/boringssl-with-bazel/src/crypto/asn1/a_enum.c',
        'third_party/boringssl-with-bazel/src/crypto/asn1/a_gentm.c',
        'third_party/boringssl-with-bazel/src/crypto/asn1/a_i2d_fp.c',
        'third_party/boringssl-with-bazel/src/crypto/asn1/a_int.c',
        'third_party/boringssl-with-bazel/src/crypto/asn1/a_mbstr.c',
        'third_party/boringssl-with-bazel/src/crypto/asn1/a_object.c',
        'third_party/boringssl-with-bazel/src/crypto/asn1/a_octet.c',
        'third_party/boringssl-with-bazel/src/crypto/asn1/a_print.c',
        'third_party/boringssl-with-bazel/src/crypto/asn1/a_strex.c',
        'third_party/boringssl-with-bazel/src/crypto/asn1/a_strnid.c',
        'third_party/boringssl-with-bazel/src/crypto/asn1/a_time.c',
        'third_party/boringssl-with-bazel/src/crypto/asn1/a_type.c',
        'third_party/boringssl-with-bazel/src/crypto/asn1/a_utctm.c',
        'third_party/boringssl-with-bazel/src/crypto/asn1/a_utf8.c',
        'third_party/boringssl-with-bazel/src/crypto/asn1/asn1_lib.c',
        'third_party/boringssl-with-bazel/src/crypto/asn1/asn1_par.c',
        'third_party/boringssl-with-bazel/src/crypto/asn1/asn_pack.c',
        'third_party/boringssl-with-bazel/src/crypto/asn1/f_int.c',
        'third_party/boringssl-with-bazel/src/crypto/asn1/f_string.c',
        'third_party/boringssl-with-bazel/src/crypto/asn1/tasn_dec.c',
        'third_party/boringssl-with-bazel/src/crypto/asn1/tasn_enc.c',
        'third_party/boringssl-with-bazel/src/crypto/asn1/tasn_fre.c',
        'third_party/boringssl-with-bazel/src/crypto/asn1/tasn_new.c',
        'third_party/boringssl-with-bazel/src/crypto/asn1/tasn_typ.c',
        'third_party/boringssl-with-bazel/src/crypto/asn1/tasn_utl.c',
        'third_party/boringssl-with-bazel/src/crypto/asn1/time_support.c',
        'third_party/boringssl-with-bazel/src/crypto/base64/base64.c',
        'third_party/boringssl-with-bazel/src/crypto/bio/bio.c',
        'third_party/boringssl-with-bazel/src/crypto/bio/bio_mem.c',
        'third_party/boringssl-with-bazel/src/crypto/bio/connect.c',
        'third_party/boringssl-with-bazel/src/crypto/bio/fd.c',
        'third_party/boringssl-with-bazel/src/crypto/bio/file.c',
        'third_party/boringssl-with-bazel/src/crypto/bio/hexdump.c',
        'third_party/boringssl-with-bazel/src/crypto/bio/pair.c',
        'third_party/boringssl-with-bazel/src/crypto/bio/printf.c',
        'third_party/boringssl-with-bazel/src/crypto/bio/socket.c',
        'third_party/boringssl-with-bazel/src/crypto/bio/socket_helper.c',
        'third_party/boringssl-with-bazel/src/crypto/blake2/blake2.c',
        'third_party/boringssl-with-bazel/src/crypto/bn_extra/bn_asn1.c',
        'third_party/boringssl-with-bazel/src/crypto/bn_extra/convert.c',
        'third_party/boringssl-with-bazel/src/crypto/buf/buf.c',
        'third_party/boringssl-with-bazel/src/crypto/bytestring/asn1_compat.c',
        'third_party/boringssl-with-bazel/src/crypto/bytestring/ber.c',
        'third_party/boringssl-with-bazel/src/crypto/bytestring/cbb.c',
        'third_party/boringssl-with-bazel/src/crypto/bytestring/cbs.c',
        'third_party/boringssl-with-bazel/src/crypto/bytestring/unicode.c',
        'third_party/boringssl-with-bazel/src/crypto/chacha/chacha.c',
        'third_party/boringssl-with-bazel/src/crypto/cipher_extra/cipher_extra.c',
        'third_party/boringssl-with-bazel/src/crypto/cipher_extra/derive_key.c',
        'third_party/boringssl-with-bazel/src/crypto/cipher_extra/e_aesccm.c',
        'third_party/boringssl-with-bazel/src/crypto/cipher_extra/e_aesctrhmac.c',
        'third_party/boringssl-with-bazel/src/crypto/cipher_extra/e_aesgcmsiv.c',
        'third_party/boringssl-with-bazel/src/crypto/cipher_extra/e_chacha20poly1305.c',
        'third_party/boringssl-with-bazel/src/crypto/cipher_extra/e_null.c',
        'third_party/boringssl-with-bazel/src/crypto/cipher_extra/e_rc2.c',
        'third_party/boringssl-with-bazel/src/crypto/cipher_extra/e_rc4.c',
        'third_party/boringssl-with-bazel/src/crypto/cipher_extra/e_tls.c',
        'third_party/boringssl-with-bazel/src/crypto/cipher_extra/tls_cbc.c',
        'third_party/boringssl-with-bazel/src/crypto/cmac/cmac.c',
        'third_party/boringssl-with-bazel/src/crypto/conf/conf.c',
        'third_party/boringssl-with-bazel/src/crypto/cpu-aarch64-fuchsia.c',
        'third_party/boringssl-with-bazel/src/crypto/cpu-aarch64-linux.c',
        'third_party/boringssl-with-bazel/src/crypto/cpu-aarch64-win.c',
        'third_party/boringssl-with-bazel/src/crypto/cpu-arm-linux.c',
        'third_party/boringssl-with-bazel/src/crypto/cpu-arm.c',
        'third_party/boringssl-with-bazel/src/crypto/cpu-intel.c',
        'third_party/boringssl-with-bazel/src/crypto/cpu-ppc64le.c',
        'third_party/boringssl-with-bazel/src/crypto/crypto.c',
        'third_party/boringssl-with-bazel/src/crypto/curve25519/curve25519.c',
        'third_party/boringssl-with-bazel/src/crypto/curve25519/spake25519.c',
        'third_party/boringssl-with-bazel/src/crypto/dh_extra/dh_asn1.c',
        'third_party/boringssl-with-bazel/src/crypto/dh_extra/params.c',
        'third_party/boringssl-with-bazel/src/crypto/digest_extra/digest_extra.c',
        'third_party/boringssl-with-bazel/src/crypto/dsa/dsa.c',
        'third_party/boringssl-with-bazel/src/crypto/dsa/dsa_asn1.c',
        'third_party/boringssl-with-bazel/src/crypto/ec_extra/ec_asn1.c',
        'third_party/boringssl-with-bazel/src/crypto/ec_extra/ec_derive.c',
        'third_party/boringssl-with-bazel/src/crypto/ec_extra/hash_to_curve.c',
        'third_party/boringssl-with-bazel/src/crypto/ecdh_extra/ecdh_extra.c',
        'third_party/boringssl-with-bazel/src/crypto/ecdsa_extra/ecdsa_asn1.c',
        'third_party/boringssl-with-bazel/src/crypto/engine/engine.c',
        'third_party/boringssl-with-bazel/src/crypto/err/err.c',
        'third_party/boringssl-with-bazel/src/crypto/evp/digestsign.c',
        'third_party/boringssl-with-bazel/src/crypto/evp/evp.c',
        'third_party/boringssl-with-bazel/src/crypto/evp/evp_asn1.c',
        'third_party/boringssl-with-bazel/src/crypto/evp/evp_ctx.c',
        'third_party/boringssl-with-bazel/src/crypto/evp/p_dsa_asn1.c',
        'third_party/boringssl-with-bazel/src/crypto/evp/p_ec.c',
        'third_party/boringssl-with-bazel/src/crypto/evp/p_ec_asn1.c',
        'third_party/boringssl-with-bazel/src/crypto/evp/p_ed25519.c',
        'third_party/boringssl-with-bazel/src/crypto/evp/p_ed25519_asn1.c',
        'third_party/boringssl-with-bazel/src/crypto/evp/p_rsa.c',
        'third_party/boringssl-with-bazel/src/crypto/evp/p_rsa_asn1.c',
        'third_party/boringssl-with-bazel/src/crypto/evp/p_x25519.c',
        'third_party/boringssl-with-bazel/src/crypto/evp/p_x25519_asn1.c',
        'third_party/boringssl-with-bazel/src/crypto/evp/pbkdf.c',
        'third_party/boringssl-with-bazel/src/crypto/evp/print.c',
        'third_party/boringssl-with-bazel/src/crypto/evp/scrypt.c',
        'third_party/boringssl-with-bazel/src/crypto/evp/sign.c',
        'third_party/boringssl-with-bazel/src/crypto/ex_data.c',
        'third_party/boringssl-with-bazel/src/crypto/fipsmodule/bcm.c',
        'third_party/boringssl-with-bazel/src/crypto/fipsmodule/fips_shared_support.c',
        'third_party/boringssl-with-bazel/src/crypto/hkdf/hkdf.c',
        'third_party/boringssl-with-bazel/src/crypto/hpke/hpke.c',
        'third_party/boringssl-with-bazel/src/crypto/hrss/hrss.c',
        'third_party/boringssl-with-bazel/src/crypto/lhash/lhash.c',
        'third_party/boringssl-with-bazel/src/crypto/mem.c',
        'third_party/boringssl-with-bazel/src/crypto/obj/obj.c',
        'third_party/boringssl-with-bazel/src/crypto/obj/obj_xref.c',
        'third_party/boringssl-with-bazel/src/crypto/pem/pem_all.c',
        'third_party/boringssl-with-bazel/src/crypto/pem/pem_info.c',
        'third_party/boringssl-with-bazel/src/crypto/pem/pem_lib.c',
        'third_party/boringssl-with-bazel/src/crypto/pem/pem_oth.c',
        'third_party/boringssl-with-bazel/src/crypto/pem/pem_pk8.c',
        'third_party/boringssl-with-bazel/src/crypto/pem/pem_pkey.c',
        'third_party/boringssl-with-bazel/src/crypto/pem/pem_x509.c',
        'third_party/boringssl-with-bazel/src/crypto/pem/pem_xaux.c',
        'third_party/boringssl-with-bazel/src/crypto/pkcs7/pkcs7.c',
        'third_party/boringssl-with-bazel/src/crypto/pkcs7/pkcs7_x509.c',
        'third_party/boringssl-with-bazel/src/crypto/pkcs8/p5_pbev2.c',
        'third_party/boringssl-with-bazel/src/crypto/pkcs8/pkcs8.c',
        'third_party/boringssl-with-bazel/src/crypto/pkcs8/pkcs8_x509.c',
        'third_party/boringssl-with-bazel/src/crypto/poly1305/poly1305.c',
        'third_party/boringssl-with-bazel/src/crypto/poly1305/poly1305_arm.c',
        'third_party/boringssl-with-bazel/src/crypto/poly1305/poly1305_vec.c',
        'third_party/boringssl-with-bazel/src/crypto/pool/pool.c',
        'third_party/boringssl-with-bazel/src/crypto/rand_extra/deterministic.c',
        'third_party/boringssl-with-bazel/src/crypto/rand_extra/forkunsafe.c',
        'third_party/boringssl-with-bazel/src/crypto/rand_extra/fuchsia.c',
        'third_party/boringssl-with-bazel/src/crypto/rand_extra/passive.c',
        'third_party/boringssl-with-bazel/src/crypto/rand_extra/rand_extra.c',
        'third_party/boringssl-with-bazel/src/crypto/rand_extra/windows.c',
        'third_party/boringssl-with-bazel/src/crypto/rc4/rc4.c',
        'third_party/boringssl-with-bazel/src/crypto/refcount_c11.c',
        'third_party/boringssl-with-bazel/src/crypto/refcount_lock.c',
        'third_party/boringssl-with-bazel/src/crypto/rsa_extra/rsa_asn1.c',
        'third_party/boringssl-with-bazel/src/crypto/rsa_extra/rsa_print.c',
        'third_party/boringssl-with-bazel/src/crypto/siphash/siphash.c',
        'third_party/boringssl-with-bazel/src/crypto/stack/stack.c',
        'third_party/boringssl-with-bazel/src/crypto/thread.c',
        'third_party/boringssl-with-bazel/src/crypto/thread_none.c',
        'third_party/boringssl-with-bazel/src/crypto/thread_pthread.c',
        'third_party/boringssl-with-bazel/src/crypto/thread_win.c',
        'third_party/boringssl-with-bazel/src/crypto/trust_token/pmbtoken.c',
        'third_party/boringssl-with-bazel/src/crypto/trust_token/trust_token.c',
        'third_party/boringssl-with-bazel/src/crypto/trust_token/voprf.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/a_digest.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/a_sign.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/a_verify.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/algorithm.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/asn1_gen.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/by_dir.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/by_file.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/i2d_pr.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/name_print.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/rsa_pss.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/t_crl.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/t_req.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/t_x509.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/t_x509a.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x509.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x509_att.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x509_cmp.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x509_d2.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x509_def.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x509_ext.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x509_lu.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x509_obj.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x509_req.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x509_set.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x509_trs.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x509_txt.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x509_v3.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x509_vfy.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x509_vpm.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x509cset.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x509name.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x509rset.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x509spki.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x_algor.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x_all.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x_attrib.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x_crl.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x_exten.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x_info.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x_name.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x_pkey.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x_pubkey.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x_req.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x_sig.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x_spki.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x_val.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x_x509.c',
        'third_party/boringssl-with-bazel/src/crypto/x509/x_x509a.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/pcy_cache.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/pcy_data.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/pcy_lib.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/pcy_map.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/pcy_node.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/pcy_tree.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/v3_akey.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/v3_akeya.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/v3_alt.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/v3_bcons.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/v3_bitst.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/v3_conf.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/v3_cpols.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/v3_crld.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/v3_enum.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/v3_extku.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/v3_genn.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/v3_ia5.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/v3_info.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/v3_int.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/v3_lib.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/v3_ncons.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/v3_ocsp.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/v3_pci.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/v3_pcia.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/v3_pcons.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/v3_pmaps.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/v3_prn.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/v3_purp.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/v3_skey.c',
        'third_party/boringssl-with-bazel/src/crypto/x509v3/v3_utl.c',
        'third_party/boringssl-with-bazel/src/ssl/bio_ssl.cc',
        'third_party/boringssl-with-bazel/src/ssl/d1_both.cc',
        'third_party/boringssl-with-bazel/src/ssl/d1_lib.cc',
        'third_party/boringssl-with-bazel/src/ssl/d1_pkt.cc',
        'third_party/boringssl-with-bazel/src/ssl/d1_srtp.cc',
        'third_party/boringssl-with-bazel/src/ssl/dtls_method.cc',
        'third_party/boringssl-with-bazel/src/ssl/dtls_record.cc',
        'third_party/boringssl-with-bazel/src/ssl/encrypted_client_hello.cc',
        'third_party/boringssl-with-bazel/src/ssl/extensions.cc',
        'third_party/boringssl-with-bazel/src/ssl/handoff.cc',
        'third_party/boringssl-with-bazel/src/ssl/handshake.cc',
        'third_party/boringssl-with-bazel/src/ssl/handshake_client.cc',
        'third_party/boringssl-with-bazel/src/ssl/handshake_server.cc',
        'third_party/boringssl-with-bazel/src/ssl/s3_both.cc',
        'third_party/boringssl-with-bazel/src/ssl/s3_lib.cc',
        'third_party/boringssl-with-bazel/src/ssl/s3_pkt.cc',
        'third_party/boringssl-with-bazel/src/ssl/ssl_aead_ctx.cc',
        'third_party/boringssl-with-bazel/src/ssl/ssl_asn1.cc',
        'third_party/boringssl-with-bazel/src/ssl/ssl_buffer.cc',
        'third_party/boringssl-with-bazel/src/ssl/ssl_cert.cc',
        'third_party/boringssl-with-bazel/src/ssl/ssl_cipher.cc',
        'third_party/boringssl-with-bazel/src/ssl/ssl_file.cc',
        'third_party/boringssl-with-bazel/src/ssl/ssl_key_share.cc',
        'third_party/boringssl-with-bazel/src/ssl/ssl_lib.cc',
        'third_party/boringssl-with-bazel/src/ssl/ssl_privkey.cc',
        'third_party/boringssl-with-bazel/src/ssl/ssl_session.cc',
        'third_party/boringssl-with-bazel/src/ssl/ssl_stat.cc',
        'third_party/boringssl-with-bazel/src/ssl/ssl_transcript.cc',
        'third_party/boringssl-with-bazel/src/ssl/ssl_versions.cc',
        'third_party/boringssl-with-bazel/src/ssl/ssl_x509.cc',
        'third_party/boringssl-with-bazel/src/ssl/t1_enc.cc',
        'third_party/boringssl-with-bazel/src/ssl/tls13_both.cc',
        'third_party/boringssl-with-bazel/src/ssl/tls13_client.cc',
        'third_party/boringssl-with-bazel/src/ssl/tls13_enc.cc',
        'third_party/boringssl-with-bazel/src/ssl/tls13_server.cc',
        'third_party/boringssl-with-bazel/src/ssl/tls_method.cc',
        'third_party/boringssl-with-bazel/src/ssl/tls_record.cc',
      ],
    },
    {
      'target_name': 'boringssl_test_util',
      'type': 'static_library',
      'dependencies': [
      ],
      'sources': [
        'third_party/boringssl-with-bazel/src/crypto/test/file_test.cc',
        'third_party/boringssl-with-bazel/src/crypto/test/malloc.cc',
        'third_party/boringssl-with-bazel/src/crypto/test/test_util.cc',
        'third_party/boringssl-with-bazel/src/crypto/test/wycheproof_util.cc',
      ],
    },
    {
      'target_name': 'benchmark',
      'type': 'static_library',
      'dependencies': [
      ],
      'sources': [
        'third_party/benchmark/src/benchmark.cc',
        'third_party/benchmark/src/benchmark_api_internal.cc',
        'third_party/benchmark/src/benchmark_main.cc',
        'third_party/benchmark/src/benchmark_name.cc',
        'third_party/benchmark/src/benchmark_register.cc',
        'third_party/benchmark/src/benchmark_runner.cc',
        'third_party/benchmark/src/check.cc',
        'third_party/benchmark/src/colorprint.cc',
        'third_party/benchmark/src/commandlineflags.cc',
        'third_party/benchmark/src/complexity.cc',
        'third_party/benchmark/src/console_reporter.cc',
        'third_party/benchmark/src/counter.cc',
        'third_party/benchmark/src/csv_reporter.cc',
        'third_party/benchmark/src/json_reporter.cc',
        'third_party/benchmark/src/perf_counters.cc',
        'third_party/benchmark/src/reporter.cc',
        'third_party/benchmark/src/sleep.cc',
        'third_party/benchmark/src/statistics.cc',
        'third_party/benchmark/src/string_util.cc',
        'third_party/benchmark/src/sysinfo.cc',
        'third_party/benchmark/src/timers.cc',
      ],
    },
    {
      'target_name': 're2',
      'type': 'static_library',
      'dependencies': [
      ],
      'sources': [
        'third_party/re2/re2/bitstate.cc',
        'third_party/re2/re2/compile.cc',
        'third_party/re2/re2/dfa.cc',
        'third_party/re2/re2/filtered_re2.cc',
        'third_party/re2/re2/mimics_pcre.cc',
        'third_party/re2/re2/nfa.cc',
        'third_party/re2/re2/onepass.cc',
        'third_party/re2/re2/parse.cc',
        'third_party/re2/re2/perl_groups.cc',
        'third_party/re2/re2/prefilter.cc',
        'third_party/re2/re2/prefilter_tree.cc',
        'third_party/re2/re2/prog.cc',
        'third_party/re2/re2/re2.cc',
        'third_party/re2/re2/regexp.cc',
        'third_party/re2/re2/set.cc',
        'third_party/re2/re2/simplify.cc',
        'third_party/re2/re2/stringpiece.cc',
        'third_party/re2/re2/tostring.cc',
        'third_party/re2/re2/unicode_casefold.cc',
        'third_party/re2/re2/unicode_groups.cc',
        'third_party/re2/util/pcre.cc',
        'third_party/re2/util/rune.cc',
        'third_party/re2/util/strutil.cc',
      ],
    },
    {
      'target_name': 'upb',
      'type': 'static_library',
      'dependencies': [
      ],
      'sources': [
        'third_party/upb/third_party/utf8_range/naive.c',
        'third_party/upb/third_party/utf8_range/range2-neon.c',
        'third_party/upb/third_party/utf8_range/range2-sse.c',
        'third_party/upb/upb/arena.c',
        'third_party/upb/upb/array.c',
        'third_party/upb/upb/decode_fast.c',
        'third_party/upb/upb/decode.c',
        'third_party/upb/upb/def.c',
        'third_party/upb/upb/encode.c',
        'third_party/upb/upb/extension_registry.c',
        'third_party/upb/upb/json_decode.c',
        'third_party/upb/upb/json_encode.c',
        'third_party/upb/upb/map.c',
        'third_party/upb/upb/mini_table.c',
        'third_party/upb/upb/msg.c',
        'third_party/upb/upb/reflection.c',
        'third_party/upb/upb/status.c',
        'third_party/upb/upb/table.c',
        'third_party/upb/upb/text_encode.c',
        'third_party/upb/upb/upb.c',
        'src/core/ext/upb-generated/google/protobuf/descriptor.upb.c',
        'src/core/ext/upbdefs-generated/google/protobuf/descriptor.upbdefs.c',
      ],
    },
    {
      'target_name': 'z',
      'type': 'static_library',
      'dependencies': [
      ],
      'sources': [
        'third_party/zlib/adler32.c',
        'third_party/zlib/compress.c',
        'third_party/zlib/crc32.c',
        'third_party/zlib/deflate.c',
        'third_party/zlib/gzclose.c',
        'third_party/zlib/gzlib.c',
        'third_party/zlib/gzread.c',
        'third_party/zlib/gzwrite.c',
        'third_party/zlib/infback.c',
        'third_party/zlib/inffast.c',
        'third_party/zlib/inflate.c',
        'third_party/zlib/inftrees.c',
        'third_party/zlib/trees.c',
        'third_party/zlib/uncompr.c',
        'third_party/zlib/zutil.c',
      ],
    },
  ]
}
