# Try to find the MPIR librairies
# See http://mpir.org/

if(MPIR_INCLUDES AND MPIR_LIBRARIES)
  set(MPIR_FIND_QUIETLY TRUE)
endif(MPIR_INCLUDES AND MPIR_LIBRARIES)

find_path(
  MPIR_INCLUDES
  NAMES
    mpir.h
  PATHS
    $ENV{MPIRDIR}
    $ENV{MPIR_INC}
    ${INCLUDE_INSTALL_DIR}
)
find_library(
  MPIR_LIBRARIES
  NAMES
    mpir
    libmpir
  PATHS
    $ENV{MPIRDIR}
    $ENV{MPIR_LIB}
    ${LIB_INSTALL_DIR}
)

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(MPIR DEFAULT_MSG MPIR_INCLUDES MPIR_LIBRARIES)
mark_as_advanced(MPIR_INCLUDES MPIR_LIBRARIES)
