import os

from conan import ConanFile
from conan.tools.cmake import CMake, cmake_layout
from conan.tools.files import collect_libs, update_conandata, copy
from conan.tools.scm import Git

required_conan_version = '>=1.53.0'

class LwipCorePackage(ConanFile):
    name = 'lwipcore'
    license = '3-clause BSD-style'
    description = 'A Lightweight TCP/IP stack'
    url = 'https://github.com/lwip-tcpip/lwip.git'

    settings = 'os', 'arch', 'compiler', 'build_type'

    options = {
        'shared': [True, False],
        'fPIC': [True, False],
    }

    default_options = {
        'shared': False,
        'fPIC': True,
    }

    generators = "CMakeDeps", "CMakeToolchain"


    def set_version(self):
        if not self.version:
            git = Git(self, self.recipe_folder)
            # NOTE: running "git status" updates the index as a side effect and fixes "git describe --dirty" output
            git.run('status')
            self.version = git.run('describe --tags --dirty --broken')


    def export(self):
        git = Git(self, self.recipe_folder)
        scm_url, scm_commit = git.get_url_and_commit()
        update_conandata(self, {"sources": {"commit": scm_commit, "url": scm_url}})


    def source(self):
        git = Git(self)
        sources = self.conan_data["sources"]
        git.clone(url=sources["url"], target=".")
        git.checkout(commit=sources["commit"])


    def layout(self):
        cmake_layout(self)


    def build(self):
        definitions = dict()
        definitions["CMAKE_BUILD_TYPE"] = self.settings.build_type

        cmake = CMake(self)
        cmake.configure(definitions)
        cmake.build()


    def package(self):
        copy(self, "COPYING", self.source_folder, os.path.join(self.package_folder, "licenses"))
        cmake = CMake(self)
        cmake.install()


    def package_info(self):
        self.cpp_info.libs = collect_libs(self)
